package cn.smarthse.services.wanda.api.entity.threeTime;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Transient;

/**
 * 万达仓数据对接-三同时-投资项目
 * @TableName three_time_investment_projects
 */
@Data
public class ThreeTimeInvestmentProjects implements Serializable {
    /**
     * 序号
     */
    @Id
    private Long id;

    /**
     * 施工许可证编号
     */
    private String constructLicenseCode;

    /**
     * 累计到位资金 单位：万元
     */
    private String fundComplete;

    /**
     * 累计完成资金 单位：万元
     */
    private String fundReceive;

    /**
     * 竣工时间 业主填写的竣工时间
     */
    private Date jgTime;

    /**
     * 开工时间 业主填写的实际开工时间
     */
    private Date kgTime;

    /**
     * 项目代码
     */
    private String projectCode;

    /**
     * 拟建成时间
     */
    @Column(name = "project_end_time")
    private String projectEndTime;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 拟开工时间
     */
    @Column(name = "project_end_time")
    private String projectStartTime;

    /**
     * 开工标识 a00001工程招投标;a00002主体开挖;a00003其他
     */
    private String startFlag;

    /**
     * 总投资额 单位：万元
     */
    private String totalMoney;
    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 最后修改人id
     */
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    @Transient
    private static final long serialVersionUID = 1L;
}