package cn.smarthse.services.wanda.api.entity.threeTime;

import lombok.Data;

import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * @author 覃浩云 1770126791@qq.com
 * @version 1.0
 * @description: 数据处理标识
 * @date 2023/4/23 11:43
 */
@Data
public class ThreeTimeBaseEntity implements Serializable {

    /**
     * 0未处理， 1处理中， 2 已处理， 3推送失败
     */
    private Byte isProc;

    /**
     * 1新增数据， 0表示数据有修改 推送时需要
     */
    private Boolean isAdd;

    /**
     * 是否需要推送， 新增和修改后都需要重置为1 表示需要推送
     */
    private Byte needPull;

    /**
     * 最后推送时间
     */
    private Date lastPullDate;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 最后修改人id
     */
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    /**
     * 数据源id
     */
    private String sourceId;

    /**
     * 推送次数
     */
    private Integer pushNum;

    @Transient
    private static final long serialVersionUID = 1L;
}
