package cn.smarthse.services.wanda.api.entity.threeTime;

import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Transient;

/**
 * 万达仓数据对接-三同时-验收意见
 * @author qinhaoyun
 * @TableName three_time_acceptance_opinions
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ThreeTimeAcceptanceOpinions implements Serializable {
    /**
     * 序号
     */
    @Id
    private Long id;
    private Long cid;

    /**
     * 事项申报号
     */
    @Column(name = "approval_item_id")
    private String approvalItemId;

    /**
     * 证照数据
     */
    private String data;

    /**
     * 审批部门编号
     */
    private String deptCode;

    /**
     * 审批部门名称
     */
    private String deptName;

    /**
     * 电子证照编码
     */
    private String elcLicenceCode;

    /**
     * 电子证照来源部门
     */
    private String elcLicenceDept;

    /**
     * 电子证照文件数据
     */
    private String elcLicenceFile;

    /**
     * 电子证照文件地址
     */
    private String elcLicenceFileUrl;

    /**
     * 电子证照名称
     */
    private String elcLicenceName;

    /**
     * 电子证照结构化数据
     */
    private String elcLicenceStruct;

    /**
     * 权力事项代码
     */
    private String itemCode;

    /**
     * 权力事项名称
     */
    private String itemName;

    /**
     * 批复时间
     */
    private Date pfDate;

    /**
     * 批复文号
     */
    private String pfDocNum;

    /**
     * 批复名称
     */
    private String pfName;

    /**
     * 项目代码
     */
    private String projectCode;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目单位名称
     */
    private String projectOrgName;

    /**
     * 文件签名证书
     */
    private String fileSignCert;

    /**
     * 文件签名值
     */
    private String fileSignValue;

    /**
     * 文件时间戳签名值
     */
    private String fileTsa;


    /**
     * 数据签名证书
     */
    private String dataSignCert;

    /**
     * 数据签名值
     */
    private String dataSignValue;

    /**
     * 数据时间戳签名值
     */
    private String dataTsa;


    /**
     * 状态
     */
    private String status;


    /**
     * 持证者主体统一社会信用代码
     */
    private String unscid;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 最后修改人id
     */
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    @Transient
    private static final long serialVersionUID = 1L;
}