package cn.smarthse.services.wanda.api.entity.feedback;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: HandleProcess
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 12
 * @since 2023/11/13-10:12
 */
@Data
@TableName("chuangde_exelaw_feedback_unhandle")
public class FeedbackUnHandle  implements Serializable {
    @Id
    private Long id;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;
    private Date createDate;

    /**
     * 最后修改人id
     */
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    private Long feedbackHandId;
    /**
     * 1 同一事件已经处置，不再重复处理；2 公安机
     * 关立案调查，行政部门不再处理；3 事件进入民
     * 事诉讼程序，行政部门不再处理；4 其它；5 约
     * 谈；6 警示；7 通报
     */
    private Integer reasonType;
    /**
     * 直接反馈处置原因
     * 类型为其他时的原
     * 因文件描述
     */
    private String reasonText;
    /**
     * 证明材料可访问的 url 地址列表，多个使用半角
     * 逗号分隔
     */
    private String fileUrls;
}
