package cn.smarthse.services.wanda.api.entity.feedback;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: HandleProcess
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 12
 * @since 2023/11/13-10:12
 */
@Data
@TableName("chuangde_exelaw_feedback_handle_check")
public class FeedbackHandleCheck implements Serializable {
    @Id
    private Long id;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;
    private Date createDate;

    /**
     * 最后修改人id
     */
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;
    private Long feedbackHandId;

    /**
     * 任务类型：1 单部门；2 跨部门
     */
    private Integer taskType;

    /**
     * 检查截止日期
     */
    private Date checkDue;
    /**
     * 分配的检查部门
     */
    private String checkDeptName;
    /**
     * 分配的检查人员，单部门时使用
     */
    private String checkPerson;
    /**
     * 分配的牵头部门，跨部门时使用
     */
    private String leadDeptName;
    /**
     * 分配的参与部门
     */
    private String joinDeptNames;
    /**
     * 任务联系人
     */
    private String taskContactPerson;
    /**
     *  任务检查内容
     */
    private String taskCheckContent;
    /**
     * 任务联系电话
     */
    private String taskContactTel;
    /**
     * 资料可访问的 url 地址列表，多个使用半角逗号分隔
     */
    private String fileUrls;
}
