package cn.smarthse.services.wanda.api.entity.feedback;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: ExelawFeedback
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 09
 * @since 2023/11/13-10:09
 */
@Data
@TableName("chuangde_exelaw_feedback")
public class ExelawFeedback implements Serializable {

    @Id
    private Long id;

    /**
     * 创建人
     */
    private Long createBy;
    private Date createDate;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 最后修改人id
     */
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;
    /**
     * 处理状态
     * 1 处理中；2 已完成（包括的情况：1 风险监测预
     * 警提示；2 创建检查任务且所有检查部门都录入
     * 检查结果;
     * ）；3 无需处置
     * ）；4 已处置-解除风险
     */
    private Integer status;
    private String cdStatus;

    /**
     * 风险处理完成后
     * 生成的报告 URL
     */
    private String reportUrl;
    /**
     * 风险系统标识
     */
    private String riskSystemId;

    /**
     * 各个系统产生的风险唯一 ID，风险信号推送时厅
     * 局系统产生的
     */
    private String uniqueid;

    /**
     * 本次接收时间
     */
    private Date accTime;
    /**
     * 处罚 ID 多个用,隔开
     */
    private String punishIds;
    /**
     * 风险处理过程
     */
    @TableField(exist = false)
    private List<FeedbackHandle> handles;
    @TableField(exist = false)
    private List<FeedbackResult> checkResults;
}
