package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * @Database: work_propose_push
 */

@Data
@TableName("chuangde_work_propose_push")
public class WorkProposePush implements Serializable{

	private static final Long serialVersionUID = -3523904501704636547L;

	/**
	 * id
	 */
  	@Id
	@Column(name = "id")
	private Long id;

	/**
	 * 未及时化解风险企业推送记录id
	 */
  	@Column(name = "work_id")
	private Long workId;

	/**
	 * 企业id
	 */
  	@Column(name = "cid")
	private Long cid;

	/**
	 * 无需化解的原因
	 */
  	@Column(name = "reason")
	private String reason;

	/**
	 * 创建人
	 */
  	@Column(name = "create_by")
	private Long createBy;

	/**
	 * 创建时间
	 */
  	@Column(name = "create_date")
	private Date createDate;

	/**
	 * 最后修改人ID
	 */
  	@Column(name = "update_by")
	private Long updateBy;

	/**
	 * 最后修改时间
	 */
  	@Column(name = "update_date")
	private Date updateDate;

	/**
	 * 是否有效（0-无效，1-有效）
	 */
  	@Column(name = "is_valid")
	private Boolean isValid;

}
