package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("wanda_zyws_suplaw_collect")
public class WandaZywsSuplawCollect implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    private Long id;
    private Long cid;
    @Transient
    private Integer yeardata;
    /***
     * 监督状态，1当年被监督，2当年未监督， >1 历年被监督；is null 从未被监督
     */
    private Integer supState;
    /**
     * 执法状态，1当年被处罚，2当年未处罚， >1 历年被处罚；is null 从未被处罚
     */
    private Integer lawState;

    private Date createDate;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 最后修改人id
     */
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

}
