package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import java.io.Serializable;

/**
 * @ClassName wandaZywsSupervsorInfo
 * @Description 监督对象信息
 * @Author 曾华川
 * @Date 2023年10月10日 11:29
 * @Version v1.0
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("wanda_zyws_supervsor_info")
public class WandaZywsSupervsorInfo extends WandaBaseData implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 原数据ID
     */
    private String sourceId;

    /**
     * 被监督对象名称
     */
    private String supervisedName;

    /**
     * 注册地址
     */
    private String registAddress;

    /**
     * 经营地址
     */
    private String businessAddress;

    /**
     * 行政区划代码
     */
    private String areaCode;

    /**
     * 社会信用代码
     */
    private String unifiedSocialCc;

    /**
     * 经济类型
     */
    private String economicType;

    /**
     * 法定代表人
     */
    private String legalName;

    /**
     * 负责人
     */
    private String manager;

    /**
     * 联系人
     */
    private String contactPerson;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 机构类型
     */
    private String orgType;

    /**
     * 许可核准项目
     */
    private String permitProject;

    /**
     * 资质证书编号
     */
    private String certNo;

    /**
     * 取得资质时间
     */
    private String getCertTime;

    /**
     * 有效期开始时间
     */
    private String validBeginTime;

    /**
     * 有效期截至时间
     */
    private String validEndTime;

    /**
     * 发证单位
     */
    private String issueUnit;

    /**
     * 技术服务业务范围
     */
    private String serviceScope;

    /**
     * 卫生许可证号
     */
    private String permitCertNo;

    /**
     * 机构种类 1.职业健康检查机构 2.职业卫生技术服务机构 3.职业病诊断机构
     */
    private String orgClass;

}
