package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import java.io.Serializable;

/**
 * @ClassName WandaZywsSupervsionInfo
 * @Description 监督数据
 * @Author 曾华川
 * @Date 2023年10月10日 14:44
 * @Version v1.0
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("wanda_zyws_supervsion_info")
public class WandaZywsSupervsionInfo extends WandaBaseData implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 原数据id
     */
    private String sourceId;

    /**
     * 被监督对象名称
     */
    private String supervisedName;

    /**
     * 统一社会信用代码
     */
    private String unifiedSocialCc;

    /**
     * 专业类别
     */
    private String professionalType;

    /**
     * 监督类别
     */
    private String supervisionType;

    /**
     * 监督日期
     */
    private String supervisionDate;

    /**
     * 监督员1
     */
    private String supervisor1;

    /**
     * 监督员2
     */
    private String supervisor2;

    /**
     * 国家监督项
     */
    private String nationSuperviseItem;

    /**
     * 检查结果
     */
    private String checkResult;

    /**
     * 后续处置/采取行动
     */
    private String disposalLater;

    /**
     * 报告单位
     */
    private String reportCom;

}
