package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 
 * </p>
 *
 * @author author
 * @since 2023-08-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("wanda_zyws_report_point")
public class WandaZywsReportPoint  extends WandaBaseData implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    private Long id;

    /**
     * 原id
     */
    private String sourceId;

    /**
     * 检测报告ID
     */
    private String reportId;

    /**
     * 检测项目编码
     */
    private String checkItemCode;
    /**
     * 危害因素名称
     */
    @TableField(exist = false)
    private String checkItemFactorName;


    /**
     * 危害因素名称(我们库里的)
     */
    @TableField(exist = false)
    private String factorName;

    /**
     * 危害因素id(我们库里的)
     */
    @TableField(exist = false)
    private Long factorId;

    /**
     * 职业病危害因素性质 1:一般 2：严重"
     */
    @TableField(exist = false)
    private Integer factorNature;

    /**
     * 作业区/车间
     */
    private String operationArea;

    /**
     * 岗位/工种
     */
    private String monitoringPoint;

    /**
     * 检测点名称
     */
    private String pointName;

    /**
     * 日接触时间
     */
    private String dailyContactTime;

    /**
     * 周工天数
     */
    private String weekWorkDay;

    /**
     * 检测日期
     */
    private Date checkDate;

    /**
     * 结论
     */
    private String conclusion;

    @TableField(exist = false)
    private List<WandaZywsReportResult> reportResultList;

}
