package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author author
 * @since 2023-08-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("wanda_zyws_report_info")
public class WandaZywsReportInfo  extends WandaBaseData implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    private Long id;

    @TableField(exist = false)
    private Long cid;

    @TableField(exist = false)
    private String companyName;

    @TableField(exist = false)
    public Long areaId;

    @TableField(exist = false)
    public String areaName;

    @TableField(exist = false)
    private Long orgId;

    @TableField(exist = false)
    private String orgName;

    private String sourceId;

    /**
     * 委托机构名称
     */
    private String entrustOrgName;

    /**
     * 委托机构统一社会信用代码
     */
    private String entrustCreditCode;

    /**
     * 委托时间
     */
    private LocalDateTime entrustDate;

    /**
     * 受检单位名称
     */
    private String inspectedOrgName;

    /**
     * 统一社会信用代码
     */
    private String inspectedCreditCode;

    /**
     * 检测机构统一社会信用代码
     */
    private String creditCode;

    /**
     * 机构名称
     */
    private String jgmc;

    /**
     * 项目负责人
     */
    private String projectDirectorName;

    /**
     * 机构负责人
     */
    private String orgDirectorName;

    /**
     * 上报机构名称
     */
    private String sbjgmc;

    /**
     * 检测报告编号
     */
    private String reportCode;

    /**
     * 检测类别 见WandaReportCheckTypeEnm
     */
    private String checkType;

    /**
     * 报告出具日期
     */
    private Date reportDate;

    /**
     * 服务的用人单位现场调查开始日期
     */
    private Date beginSurveyDate;

    /**
     * 服务的用人单位现场调查结束日期
     */
    private Date endSurveyDate;

    /**
     * 服务的用人单位现场采样、测量开始日期
     */
    private Date beginSamplingDate;

    /**
     * 服务的用人单位现场采样、测量结束日期
     */
    private Date endSamplingDate;
}
