package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import java.io.Serializable;

/**
 * @ClassName WandaZywsPunishInfo
 * @Description 处罚数据
 * @Author 曾华川
 * @Date 2023年10月10日 15:04
 * @Version v1.0
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("wanda_zyws_punish_info")
public class WandaZywsPunishInfo extends WandaBaseData implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 原数据id
     */
    private String sourceId;

    /**
     * 被监督对象名称
     */
    private String supervisedName;

    /**
     * 统一社会信用代码
     */
    private String unifiedSocialCc;

    /**
     * 专业类别 1.放射诊疗机构 2.职业健康检查机构 3.职业卫生技术服务机构
     *         4.用人单位 5.职业病诊断机构 6.放射卫生技术机构
     */
    private String professionalType;

    /**
     * 案件来源
     */
    private String caseFrom;

    /**
     * 违法事实
     */
    private String illegalFact;

    /**
     * 处罚程序 1.简易程序 2.一般程序
     */
    private String punishProject;

    /**
     * 立案日期
     */
    private String registerDate;

    /**
     * 决定日期
     */
    private String determineDate;

    /**
     * 决定书送达日期
     */
    private String sendDate;

    /**
     * 处罚文号或编号
     */
    private String punishNo;

    /**
     * 行政处罚决定
     */
    private String punishDetermine;

    /**
     * 处罚依据
     */
    private String punishBase;

    /**
     * 是否结案
     */
    private String isEnd;

    /**
     * 结案情况
     */
    private String endSituation;

    /**
     * 是否申请法院强制执行
     */
    private String isEnfroce;

    /**
     * 执行方式
     */
    private String excuteWay;

    /**
     * 执行结果
     */
    private String excuteResult;

    /**
     * 实际履行罚款金额
     */
    private String actualFine;

    /**
     * 加处罚款金额
     */
    private String extraFine;

    /**
     * 是否不予行政处罚
     */
    private String isUnpunish;

    /**
     * 是否轻微违法不予处罚
     */
    private String isMinorViolate;

    /**
     * 结案日期
     */
    private String closeDate;

    /**
     * 其他处理情况
     */
    private String otherDeal;

    /**
     * 主办人员
     */
    private String mainer;

    /**
     * 协办人员
     */
    private String coPerson;

    /**
     * 报告单位
     */
    private String reportCom;

}
