package cn.smarthse.services.wanda.api.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 职业卫生-职业病病例
 * @author 吴嘉诚
 * @date 2022/10/31
 * @desc
 */
@Table(name = "wanda_zyws_odc_base")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public @Data
class WandaZywsOdcBase extends WandaBaseData implements Serializable {

    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 数据源ID
     */
    @Column(name = "source_id")
    private String sourceId;

    /**
     * 姓名
     */
    @Column(name = "name")
    private String name;

    /**
     * 身份证件类别
     */
    @Column(name = "idcard_type")
    private String idcardType;

    /**
     * 身份证件号码
     */
    @Column(name = "idcard_code")
    private String idcardCode;

    /**
     * 性别编码
     */
    @Column(name = "sex_code")
    private String sexCode;

    /**
     * 出生日期
     */
    @Column(name = "birthday")
    private Date birthday;

    /**
     * 联系电话
     */
    @Column(name = "tel_phone")
    private String telPhone;

    /**
     * 统一社会信用代码
     */
    @Column(name = "credit_code")
    private String creditCode;

    /**
     * 用人单位名称
     */
    @Column(name = "employer_name")
    private String employerName;

    /**
     * 经济类型编码
     */
    @Column(name = "economic_type_code")
    private String economicTypeCode;

    /**
     * 行业类别编码
     */
    @Column(name = "industry_category_code")
    private String industryCategoryCode;

    /**
     * 企业规模编码
     */
    @Column(name = "enterprise_size_code")
    private String enterpriseSizeCode;

    /**
     * 所属地区编码
     */
    @Column(name = "area_code")
    private String areaCode;

    /**
     * 用人单位所在区名称
     */
    @Column(name = "area_name")
    private String areaName;

    /**
     * 通讯地址
     */
    @Column(name = "address")
    private String address;

    /**
     * 邮政编码
     */
    @Column(name = "address_zip_code")
    private String addressZipCode;

    /**
     * 用人单位联系人
     */
    @Column(name = "contact_person")
    private String contactPerson;

    /**
     * 用人单位联系电话
     */
    @Column(name = "employer_phone")
    private String employerPhone;

    /**
     * 用工单位统一社会信用代码
     */
    @Column(name = "credit_code_employer")
    private String creditCodeEmployer;

    /**
     * 用工单位名称
     */
    @Column(name = "employer_name_employer")
    private String employerNameEmployer;

    /**
     * 用工单位企业（经济）类型代码
     */
    @Column(name = "economic_type_code_employer")
    private String economicTypeCodeEmployer;

    /**
     * 用工单位行业类别代码
     */
    @Column(name = "ygdwhylbdm")
    private String ygdwhylbdm;

    /**
     * 用工单位企业规模代码
     */
    @Column(name = "enterprise_size_code_employer")
    private String enterpriseSizeCodeEmployer;

    /**
     * 用工单位所属地区代码
     */
    @Column(name = "area_code_employer")
    private String areaCodeEmployer;

    /**
     * 用工单位所在区全名称
     */
    @Column(name = "area_name_employer")
    private String areaNameEmployer;

    /**
     * 诊断登记日期
     */
    @Column(name = "apply_diagnose_date")
    private Date applyDiagnoseDate;

    /**
     * 接触的职业病危害因素
     */
    @Column(name = "hazard_code")
    private String hazardCode;

    /**
     * 接害开始日期
     */
    @Column(name = "hazard_start_date")
    private Date hazardStartDate;

    /**
     * 实际接触危害因素工龄年
     */
    @Column(name = "hazard_year")
    private String hazardYear;

    /**
     * 实际接触危害因素工龄月
     */
    @Column(name = "hazard_month")
    private String hazardMonth;

    /**
     * 职业病种类
     */
    @Column(name = "disease_type_code")
    private String diseaseTypeCode;

    /**
     * 职业病名称
     */
    @Column(name = "disease_code")
    private String diseaseCode;

    /**
     * 诊断日期
     */
    @Column(name = "diagnose_date")
    private Date diagnoseDate;

    /**
     * 死亡日期
     */
    @Column(name = "die_date")
    private Date dieDate;

    /**
     * 死亡原因
     */
    @Column(name = "die_reason_code")
    private String dieReasonCode;

    /**
     * 组织诊断单位名称
     */
    @Column(name = "zddwmc")
    private String zddwmc;

    /**
     * 诊断单位负责人
     */
    @Column(name = "diagnose_person")
    private String diagnosePerson;

    /**
     * 诊断医师单位
     */
    @Column(name = "zdysdw")
    private String zdysdw;

    /**
     * 报告人姓名
     */
    @Column(name = "report_person")
    private String reportPerson;

    /**
     * 联系电话
     */
    @Column(name = "report_person_tel")
    private String reportPersonTel;

    /**
     * 报告日期
     */
    @Column(name = "report_date")
    private Date reportDate;

    /**
     * 报告单位
     */
    @Column(name = "report_unit")
    private String reportUnit;

    /**
     * 业务库数据产生时间
     */
    /*@Column(name = "biz_time")
    private Date bizTime;*/

    /**
     * 数据仓数据记录时间
     */
    /*@Column(name = "load_time")
    private Date loadTime;*/

    /**
     * 是否有效（0-无效，1-有效）
     */
    /*@Column(name = "is_valid")
    private Boolean isValid;*/

    /**
     * 创建人ID
     */
    /*@Column(name = "create_by")
    private Long createBy;*/

    /**
     * 创建时间
     */
    /*@Column(name = "create_date")
    private Date createDate;*/

    /**
     * 最后修改人ID
     */
    /*@Column(name = "update_by")
    private Long updateBy;*/

    /**
     * 最后修改时间
     */
    /*@Column(name = "update_date")
    private Date updateDate;*/

}
