package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 万达仓对接-检测子表-检测指标(WandaZywsCheckTarget)表实体类
 *
 * @author zhangxu
 * @since 2024-04-07
 */
@Data
@ApiModel(value = "万达仓对接-检测子表-检测指标(WandaZywsCheckTarget)")
@Accessors(chain = true)
@SuppressWarnings("serial")
@TableName(value = "wanda_zyws_check_target")
public class WandaZywsCheckTarget implements Serializable  {

    private static final long serialVersionUID = 437512572559864406L;


    /**
     * id
     */
    @TableField(value = "id")
    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 万达仓对接-检测子表-检测危害因素总表ID
     */
    @TableField(value = "factors_id")
    @ApiModelProperty(value = "万达仓对接-检测子表-检测危害因素总表ID")
    private String factorsId;

    /**
     * 属性名
     */
    @TableField(value = "attr_name")
    @ApiModelProperty(value = "属性名")
    private String attrName;

    /**
     * 属性值
     */
    @TableField(value = "attr_value")
    @ApiModelProperty(value = "属性值")
    private String attrValue;

    /**
     * 描述
     */
    @TableField(value = "description")
    @ApiModelProperty(value = "描述")
    private String description;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @TableField(value = "is_valid")
    @ApiModelProperty(value = "是否有效（0-无效，1-有效）")
    private Boolean isValid;

    /**
     * 创建人
     */
    @TableField(value = "create_by")
    @ApiModelProperty(value = "创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @TableField(value = "create_date")
    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @TableField(value = "update_by")
    @ApiModelProperty(value = "最后修改人ID")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @TableField(value = "update_date")
    @ApiModelProperty(value = "最后修改时间")
    private Date updateDate;
}
