package cn.smarthse.services.wanda.api.entity;

/**
 * @author 吴嘉诚
 * @date 2023/3/3 9:19
 * @desc
 */

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * 万达仓对接-检测子表-检测危害因素总表
 */
@Data
@TableName(value ="wanda_zyws_check_factors")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class WandaZywsCheckFactors extends WandaBaseData implements Serializable {

    private static final long serialVersionUID = -37479901794539608L;


    /**
     * id
     */
    @TableField(value = "id")
    @ApiModelProperty(value = "id")
    private String id;

    /**
     * 数据源ID
     */
    @TableField(value = "source_id")
    @ApiModelProperty(value = "数据源ID")
    private String sourceId;

    /**
     * 主表id（ZYWS_CHECK表的ID）
     */
    @TableField(value = "check_id")
    @ApiModelProperty(value = "主表id（ZYWS_CHECK表的ID）")
    private String checkId;

    /**
     * 车间名称
     */
    @TableField(value = "workshop")
    @ApiModelProperty(value = "车间名称")
    private String workshop;

    /**
     * 岗位/工种
     */
    @TableField(value = "work_name")
    @ApiModelProperty(value = "岗位/工种")
    private String workName;

    /**
     * 定员
     */
    @TableField(value = "work_num")
    @ApiModelProperty(value = "定员")
    private String workNum;

    /**
     * 检测点/检测对象名称
     */
    @TableField(value = "check_point")
    @ApiModelProperty(value = "检测点/检测对象名称")
    private String checkPoint;

    /**
     * 危害因素id
     */
    @TableField(value = "factor_id")
    @ApiModelProperty(value = "危害因素id")
    private Long factorId;

    /**
     * 危害因素名称
     */
    @TableField(value = "factor_name")
    @ApiModelProperty(value = "危害因素名称")
    private String factorName;

    /**
     * 结果判断（1.不判定，2.符合，3.不符合）
     */
    @TableField(value = "judge_result")
    @ApiModelProperty(value = "结果判断（1.不判定，2.符合，3.不符合）")
    private Integer judgeResult;


    /**
     * 是否需要推送（0-否，1-是）
     */
    @TableField(value = "need_pull")
    @ApiModelProperty(value = "是否需要推送（0-否，1-是）")
    private Byte needPull;

    /**
     * 推送失败次数
     */
    @TableField(value = "push_num")
    @ApiModelProperty(value = "推送失败次数")
    private Integer pushNum;

    /**
     * 最后一次推送时间
     */
    @TableField(value = "last_pull_date")
    @ApiModelProperty(value = "最后一次推送时间")
    private Date lastPullDate;

    /**
     * appkey序号
     */
    @TableField(value = "appkey_index")
    @ApiModelProperty(value = "appkey序号")
    private Integer appkeyIndex;

    /**
     * 危害因素项ID
     */
    @TableField(value = "item_id")
    @ApiModelProperty(value = "危害因素项ID")
    private Integer itemId;


    @TableField(exist = false)
    private Long area;

    @TableField(exist = false)
    private Long occuHazardType;

    /* 化学危害因素 */
    @TableField(exist = false)
    private String cmeCmac;

    @TableField(exist = false)
    private String ctwa;

    @TableField(exist = false)
    private String csteCstel;

    @TableField(exist = false)
    private String exceedPeak;

    @TableField(exist = false)
    private String reductionFactorType;

    @TableField(exist = false)
    private String reductionFactor;

    /* 粉尘危害因素 */
    @TableField(exist = false)
    private String totalCtwa;

    @TableField(exist = false)
    private String totalRange;

    @TableField(exist = false)
    private String totalExceedPeak;

    @TableField(exist = false)
    private String totalReductionFactorType;

    @TableField(exist = false)
    private String totalReductionFactor;

    @TableField(exist = false)
    private String totalJudgeResult;

    @TableField(exist = false)
    private String respirableCtwa;

    @TableField(exist = false)
    private String respirableRange;

    @TableField(exist = false)
    private String respirableExceedPeak;

    @TableField(exist = false)
    private String respiReductionFactorType;

    @TableField(exist = false)
    private String respirableReductionFactor;

    @TableField(exist = false)
    private String respirableJudgeResult;

    /* 噪声 */
    @TableField(exist = false)
    private String noiseType;

    @TableField(exist = false)
    private String checkValue;

    @TableField(exist = false)
    private String checkValueMin;

    @TableField(exist = false)
    private String checkValueMax;

    @TableField(exist = false)
    private String checkValue840;

    @TableField(exist = false)
    private String touchTimes;  //工作日接触脉冲次数

    @TableField(exist = false)
    private String noisePeak;

    /* 高温 */
    @TableField(exist = false)
    private String touchTime;   ////接触时间率（%）

    @TableField(exist = false)
    private String physicalStrength;

    /*@TableField(exist = false)
    private String checkValue;*/

    /* 工频电场 */
    /*@TableField(exist = false)
    private String touchTime;   //接触时间率（%）*/

    @TableField(exist = false)
    private String freqStrength;

    /* 照度 */
   /*@TableField(exist = false)
    private String checkValue;*/

    /* 控制风速 */
     /*@TableField(exist = false)
    private String checkValue;*/

    /* 新风量 */
    @TableField(exist = false)
    private String staffNum;

    /*@TableField(exist = false)
    private String checkValue;*/

    /* 微小气候 */
    @TableField(exist = false)
    private String temperature;

    @TableField(exist = false)
    private String tempJudgeResult;

    @TableField(exist = false)
    private String windSpeed;

    @TableField(exist = false)
    private String windJudgeResult;

    @TableField(exist = false)
    private String humidity;

    @TableField(exist = false)
    private String humiJudgeResult;

    /* 紫外辐射 */
    @TableField(exist = false)
    private String ultraType;

    /*@TableField(exist = false)
    private String touchTime;   //接触时间（h）*/

    @TableField(exist = false)
    private String irradiance;

    @TableField(exist = false)
    private String exposure;

    @TableField(exist = false)
    private String eyeIrradiance;

    @TableField(exist = false)
    private String eyeExposure;

    @TableField(exist = false)
    private String eyeJudgeResult;

    @TableField(exist = false)
    private String faceIrradiance;

    @TableField(exist = false)
    private String faceExposure;

    @TableField(exist = false)
    private String faceJudgeResult;

    @TableField(exist = false)
    private String noneIrradiance;

    @TableField(exist = false)
    private String noneExposure;

    @TableField(exist = false)
    private String noneJudgeResult;

    /* 手传振动 */
    /*@TableField(exist = false)
    private String touchTime;   //接触时间（h）*/

    @TableField(exist = false)
    private String accelet4h;

    /* 超高频辐射 */
    @TableField(exist = false)
    private String uhfrType;

    /*@TableField(exist = false)
    private String touchTime;   //接触时间（h）*/

    @TableField(exist = false)
    private String powerDensity;

    @TableField(exist = false)
    private String uhfrStrength;

    /* 高频电磁场 */
    @TableField(exist = false)
    private String frequency;

    /*@TableField(exist = false)
    private String touchTime;   //接触时间（h）*/

    @TableField(exist = false)
    private String eletricStrength;

    @TableField(exist = false)
    private String magneticStrength;

    /* 激光辐射 */
    @TableField(exist = false)
    private String touchPart;

     /*@TableField(exist = false)
    private String touchTime;   //接触时间（h）*/

    @TableField(exist = false)
    private String radiRange;

    @TableField(exist = false)
    private String waveLength;

    @TableField(exist = false)
    private String exposTime;

    @TableField(exist = false)
    private String exposAmount;

    @TableField(exist = false)
    private String radiance;

    /* 微波辐射 */
    @TableField(exist = false)
    private String radiType;

    @TableField(exist = false)
    private String waveType;

    @TableField(exist = false)
    private String radiTime;

    @TableField(exist = false)
    private String daily;

    @TableField(exist = false)
    private String average;

    @TableField(exist = false)
    private String touchDensity;

    /* 生物因素 */
    /*@TableField(exist = false)
    private String cmeCmac;*/

    /*@TableField(exist = false)
    private String ctwa;*/

    /*@TableField(exist = false)
    private String csteCstel;*/

    /*@TableField(exist = false)
    private Integer reductionFactorType;*/

    /*@TableField(exist = false)
    private Integer reductionFactor;*/

    /* 电离辐射-射线装置 */
    @TableField(exist = false)
    private String deviceName;

    @TableField(exist = false)
    private String deviceModel;

    @TableField(exist = false)
    private String apacity;

    @TableField(exist = false)
    private String checkCondition;

    @TableField(exist = false)
    private String placeName;

    /*@TableField(exist = false)
    private String checkValue;*/

    /* 电离辐射-含源装置 */
    /*@TableField(exist = false)
    private String deviceName;*/

    @TableField(exist = false)
    private String rayNum;

    @TableField(exist = false)
    private String no;

    @TableField(exist = false)
    private String nuclide;

    @TableField(exist = false)
    private String cuActivity;

    @TableField(exist = false)
    private String exActivity;

    @TableField(exist = false)
    private String installPosition;

    @TableField(exist = false)
    private String reason;

    /*@TableField(exist = false)
    private String checkValue;*/
}
