package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;


/**
 * 万达仓对接-检测主表(WandaZywsCheck)表实体类
 *
 * @author zhangxu
 * @since 2024-04-07
 */
@Data
@ApiModel(value = "万达仓对接-检测主表(WandaZywsCheck)")
@Accessors(chain = true)
@SuppressWarnings("serial")
@TableName(value = "wanda_zyws_check")
public class WandaZywsCheck extends WandaBaseData implements Serializable {

    private static final long serialVersionUID = 141128821130892001L;


    /**
     * id
     */
    @TableField(value = "id")
    @ApiModelProperty(value = "id")
    private String id;

    /**
     * 数据源ID
     */
    @TableField(value = "source_id")
    @ApiModelProperty(value = "数据源ID")
    private String sourceId;

    /**
     * 检测类型（2：定期检测，3：现状评价，4：控制效果评价）
     */
    @TableField(value = "check_type")
    @ApiModelProperty(value = "检测类型（2：定期检测，3：现状评价，4：控制效果评价）")
    private Byte checkType;

    /**
     * 技术服务机构统一社会信用代码
     */
    @TableField(value = "org_code")
    @ApiModelProperty(value = "技术服务机构统一社会信用代码")
    private String orgCode;

    /**
     * 技术服务机构名称
     */
    @TableField(value = "org_name")
    @ApiModelProperty(value = "技术服务机构名称")
    private String orgName;

    /**
     * 技术服务机构法人名称
     */
    @TableField(value = "legal_name")
    @ApiModelProperty(value = "技术服务机构法人名称")
    private String legalName;

    /**
     * 技术服务机构法人电话
     */
    @TableField(value = "legal_phone")
    @ApiModelProperty(value = "技术服务机构法人电话")
    private String legalPhone;

    /**
     * 机构注册行政区划编码
     */
    @TableField(value = "register_area")
    @ApiModelProperty(value = "机构注册行政区划编码")
    private Long registerArea;

    /**
     * 机构注册地址详情
     */
    @TableField(value = "register_address")
    @ApiModelProperty(value = "机构注册地址详情")
    private String registerAddress;

    /**
     * 是否可以开展业务（0:不可以，1：可以）
     */
    @TableField(value = "can_service")
    @ApiModelProperty(value = "是否可以开展业务（0:不可以，1：可以）")
    private Byte canService;

    /**
     * 用人单位统一社会信用代码
     */
    @TableField(value = "com_code")
    @ApiModelProperty(value = "用人单位统一社会信用代码")
    private String comCode;

    /**
     * 用人单位名称
     */
    @TableField(value = "com_name")
    @ApiModelProperty(value = "用人单位名称")
    private String comName;

    /**
     * 检测项目编号
     */
    @TableField(value = "detect_name")
    @ApiModelProperty(value = "检测项目编号")
    private String detectName;

    /**
     * 项目名称
     */
    @TableField(value = "project_name")
    @ApiModelProperty(value = "项目名称")
    private String projectName;

    /**
     * 检测开始时间
     */
    @TableField(value = "check_date")
    @ApiModelProperty(value = "检测开始时间")
    private String checkDate;

    /**
     * 检测结束时间
     */
    @TableField(value = "check_date_end")
    @ApiModelProperty(value = "检测结束时间")
    private String checkDateEnd;

    /**
     * 对应的gbz2.1标准（1:2007标准, 2:2019标准）
     */
    @TableField(value = "target_standard_id")
    @ApiModelProperty(value = "对应的gbz2.1标准（1:2007标准, 2:2019标准）")
    private Long targetStandardId;

    /**
     * 项目区域id
     */
    @TableField(value = "project_area_id")
    @ApiModelProperty(value = "项目区域id")
    private Long projectAreaId;

    /**
     * 项目详细地址
     */
    @TableField(value = "project_address")
    @ApiModelProperty(value = "项目详细地址")
    private String projectAddress;

    /**
     * 报告出具时间
     */
    @TableField(value = "report_date")
    @ApiModelProperty(value = "报告出具时间")
    private String reportDate;

    /**
     * 职业病危害风险类别（1.严重，2.一般）
     */
    @TableField(value = "risk_level")
    @ApiModelProperty(value = "职业病危害风险类别（1.严重，2.一般）")
    private Byte riskLevel;

    /**
     * 检测报告
     */
    @TableField(value = "report_file")
    @ApiModelProperty(value = "检测报告")
    private String reportFile;

    /**
     * 检测委托书
     */
    @TableField(value = "contract_file")
    @ApiModelProperty(value = "检测委托书")
    private String contractFile;

    /**
     * 检测点分布示意图
     */
    @TableField(value = "point_map_file")
    @ApiModelProperty(value = "检测点分布示意图")
    private String pointMapFile;

    /**
     * 登记人姓名
     */
    @TableField(value = "register_name")
    @ApiModelProperty(value = "登记人姓名")
    private String registerName;

    /**
     * 登记时间
     */
    @TableField(value = "register_time")
    @ApiModelProperty(value = "登记时间")
    private String registerTime;

    /**
     * 行业名称
     */
    @TableField(value = "industry_name")
    @ApiModelProperty(value = "行业名称")
    private String industryName;

    /**
     * 行业类型
     */
    @TableField(value = "industry_code")
    @ApiModelProperty(value = "行业类型")
    private String industryCode;

    /**
     * 是否需要推送（0-否，1-是）
     */
    @TableField(value = "need_pull")
    @ApiModelProperty(value = "是否需要推送（0-否，1-是）")
    private Byte needPull;

    /**
     * 推送失败次数
     */
    @TableField(value = "push_num")
    @ApiModelProperty(value = "推送失败次数")
    private Integer pushNum;

    /**
     * 最后一次推送时间
     */
    @TableField(value = "last_pull_date")
    @ApiModelProperty(value = "最后一次推送时间")
    private Date lastPullDate;

    @TableField(exist = false)
    private Long cid;

    @TableField(exist = false)
    private String reason;
}