package cn.smarthse.services.wanda.api.entity;

import java.util.Date;
import java.io.Serializable;
import lombok.Data;

/**
 * 万达仓培训数据-此表数据是 从万达仓拉取的培训数据(WandaTrainData)表实体类
 *
 * @author Supw
 * @since 2023-06-12 14:33:57
 */
@Data
public class WandaTrainData extends WandaBaseData implements Serializable{
        //序号
        private Long id;
        private Long cid;
        //培训方式（1.线上；2.线下）
        private Integer trainWay;
        //培训地点（线下才需要填）
        private String trainAddress;
        //培训项目名称
        private String trainName;
        //培训项目编号
        private String trainNum;
        //培训开始时间
        private Date trainDateBegin;
        //培训结束时间
        private Date trainDateEnd;
        //培训类型（1.初次培训 2.继续教育）
        private Integer trainType;
        //培训项目区域
        private String trainArea;
        //培训组织单位
        private String trainRegister;
        //培训上报时间
        private Date trainReportDate;
        //培训人员姓名
        private String staffName;
        //培训人员身份证
        private String idCard;
        //培训人员联系电话
        private String staffPhone;
        //培训人员所在单位
        private String staffComName;
        //培训人员所在单位信用代码
        private String staffComCode;
        //培训课时
        private String trainHour;
        //考核结果
        private String examResult;
        //证书类型（12：企业主要负责人证书，13：管理人员证书）
        private Integer certType;
        //证书编号
        private String certNum;
        //发证日期
        private Date certCreateDate;
        //证书有效期
        private Date certValidyDate;
        //证书下载地址
        private String certDownloadUrl;
        //1.职业健康在线，2.杭州培训
        private Integer dataSource;
        //创建时间
        private Date createDate;
        //创建人
        private Long createBy;
        //最后修改时间
        private Date updateDate;
        //最后修改人ID
        private Long updateBy;
        //是否有效（0-无效，1-有效）
        private Boolean isValid;
        //数据源ID
        private String sourceId;

        private Byte isUsed;


}

