package cn.smarthse.services.wanda.api.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import java.io.Serializable;

/**
 * 职业卫生-职业病危害因素检测
 *
 * @TableName report_info
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
//@TableName(value = "wanda_report_info")
public class WandaReportInfo extends WandaBaseData implements Serializable {

    //    @TableField(exist = false)
    private static final long serialVersionUID = 6105890596986101256L;

    @Id
    private Long id;

    /**
     * 唯一标识
     */
    @ApiModelProperty("唯一标识")
//    @TableField(value = "source_id")
    private String sourceId;

    /**
     * 委托机构名称
     */
    @ApiModelProperty("委托机构名称")
//    @TableField(value = "entrust_org_name")
    private String entrustOrgName;

    /**
     * 委托机构统一社会信用代码
     */
    @ApiModelProperty("委托机构统一社会信用代码")
//    @TableField(value = "entrust_credit_code")
    private String entrustCreditCode;

    /**
     * 委托时间
     */
    @ApiModelProperty("委托时间")
//    @TableField(value = "entrust_date")
    private String entrustDate;

    /**
     * 受检单位名称
     */
    @ApiModelProperty("受检单位名称")
//    @TableField(value = "inspected_org_name")
    private String inspectedOrgName;

    /**
     * 统一社会信用代码
     */
    @ApiModelProperty("统一社会信用代码")
//    @TableField(value = "inspected_credit_code")
    private String inspectedCreditCode;

    /**
     * 经济类型编码
     */
    @ApiModelProperty("经济类型编码")
//    @TableField(value = "inspected_economic_code")
    private String inspectedEconomicCode;

    /**
     * 行业类别编码
     */
    @ApiModelProperty("行业类别编码")
//    @TableField(value = "inspected_industry_code")
    private String inspectedIndustryCode;

    /**
     * 企业规模编码
     */
    @ApiModelProperty("企业规模编码")
//    @TableField(value = "inspected_scale_code")
    private String inspectedScaleCode;

    /**
     * 注册地区编码
     */
    @ApiModelProperty("注册地区编码")
//    @TableField(value = "inspected_reg_area_code")
    private String inspectedRegAreaCode;

    /**
     * 注册地区名称
     */
    @ApiModelProperty("注册地区名称")
//    @TableField(value = "inspected_reg_area_name")
    private String inspectedRegAreaName;

    /**
     * 注册地址
     */
    @ApiModelProperty("注册地址")
//    @TableField(value = "inspected_reg_address")
    private String inspectedRegAddress;

    /**
     * 在职职工总人数
     */
    @ApiModelProperty("在职职工总人数")
//    @TableField(value = "employees_total_num")
    private String employeesTotalNum;

    /**
     * 接触危害因素员工总人数
     */
    @ApiModelProperty("接触危害因素员工总人数")
//    @TableField(value = "contact_pests_num")
    private String contactPestsNum;

    /**
     * 技术服务地区编码
     */
    @ApiModelProperty("技术服务地区编码")
//    @TableField(value = "service_address_code")
    private String serviceAddressCode;

    /**
     * 技术服务地址
     */
    @ApiModelProperty("技术服务地址")
//    @TableField(value = "service_address")
    private String serviceAddress;

    /**
     * 服务的用人单位技术服务领域编码
     */
    @ApiModelProperty("服务的用人单位技术服务领域编码")
//    @TableField(value = "service_field")
    private String serviceField;

    /**
     * 通讯地址
     */
    @ApiModelProperty("通讯地址")
//    @TableField(value = "postal_address")
    private String postalAddress;

    /**
     * 邮政编码
     */
    @ApiModelProperty("邮政编码")
//    @TableField(value = "postal_code")
    private String postalCode;

    /**
     * 法人姓名
     */
    @ApiModelProperty("法人姓名")
//    @TableField(value = "legal_person")
    private String legalPerson;

    /**
     * 法人联系电话
     */
    @ApiModelProperty("法人联系电话")
//    @TableField(value = "legal_person_phone")
    private String legalPersonPhone;

    /**
     * 联系人
     */
    @ApiModelProperty("联系人")
//    @TableField(value = "contact_person")
    private String contactPerson;

    /**
     * 联系电话
     */
    @ApiModelProperty("联系电话")
//    @TableField(value = "contact_phone")
    private String contactPhone;

    /**
     * 统一社会信用代码
     */
    @ApiModelProperty("统一社会信用代码")
//    @TableField(value = "credit_code")
    private String creditCode;

    /**
     * 机构名称
     */
    @ApiModelProperty("机构名称")
//    @TableField(value = "jgmc")
    private String jgmc;

    /**
     * 项目负责人
     */
    @ApiModelProperty("项目负责人")
//    @TableField(value = "project_director_name")
    private String projectDirectorName;

    /**
     * 机构负责人
     */
    @ApiModelProperty("机构负责人")
//    @TableField(value = "org_director_name")
    private String orgDirectorName;

    /**
     * 上报机构名称
     */
    @ApiModelProperty("上报机构名称")
//    @TableField(value = "sbjgmc")
    private String sbjgmc;

    /**
     * 检测报告编号
     */
    @ApiModelProperty("检测报告编号")
//    @TableField(value = "report_code")
    private String reportCode;

    /**
     * 检测类别
     */
    @ApiModelProperty("检测类别")
//    @TableField(value = "check_type")
    private String checkType;

    /**
     * 报告出具日期
     */
    @ApiModelProperty("报告出具日期")
//    @TableField(value = "report_date")
    private String reportDate;

    /**
     * 填表人
     */
    @ApiModelProperty("填表人")
//    @TableField(value = "preparer")
    private String preparer;

    /**
     * 填表人联系电话
     */
    @ApiModelProperty("填表人联系电话")
//    @TableField(value = "preparer_contact_way")
    private String preparerContactWay;

    /**
     * 报告签发人
     */
    @ApiModelProperty("报告签发人")
//    @TableField(value = "issuer")
    private String issuer;

    /**
     * 服务的用人单位现场调查开始日期
     */
    @ApiModelProperty("服务的用人单位现场调查开始日期")
//    @TableField(value = "begin_survey_date")
    private String beginSurveyDate;

    /**
     * 服务的用人单位现场调查结束日期
     */
    @ApiModelProperty("服务的用人单位现场调查结束日期")
//    @TableField(value = "end_survey_date")
    private String endSurveyDate;

    /**
     * 服务的用人单位现场采样、测量开始日期
     */
    @ApiModelProperty("服务的用人单位现场采样、测量开始日期")
//    @TableField(value = "begin_sampling_date")
    private String beginSamplingDate;

    /**
     * 服务的用人单位现场采样、测量结束日期
     */
    @ApiModelProperty("服务的用人单位现场采样、测量结束日期")
//    @TableField(value = "end_sampling_date")
    private String endSamplingDate;

    /**
     * 姓名
     */
    @ApiModelProperty("姓名")
//    @TableField(value = "name")
    private String name;

    /**
     * 服务事项编码
     */
    @ApiModelProperty("服务事项编码")
//    @TableField(value = "item_code")
    private String itemCode;

    /**
     * 服务事项名称
     */
    @ApiModelProperty("服务事项名称")
//    @TableField(value = "fwsxmc")
    private String fwsxmc;

    /**
     * 检测项目编码
     */
    @ApiModelProperty("检测项目编码")
//    @TableField(value = "check_item_code")
    private String checkItemCode;

    /**
     * 其他粉尘检测项目名称
     */
    @ApiModelProperty("其他粉尘检测项目名称")
//    @TableField(value = "qtfcmc")
    private String qtfcmc;

    /**
     * 作业区/车间
     */
    @ApiModelProperty("作业区/车间")
//    @TableField(value = "operation_area")
    private String operationArea;

    /**
     * 岗位/工种/检测点
     */
    @ApiModelProperty("岗位/工种/检测点")
//    @TableField(value = "monitoring_point")
    private String monitoringPoint;

    /**
     * 日接触时间
     */
    @ApiModelProperty("日接触时间")
//    @TableField(value = "daily_contact_time")
    private String dailyContactTime;

    /**
     * 周工作天数
     */
    @ApiModelProperty("周工作天数")
//    @TableField(value = "week_work_day")
    private String weekWorkDay;

    /**
     * 检测点位
     */
    @ApiModelProperty("检测点位")
//    @TableField(value = "point_name")
    private String pointName;

    /**
     * 采样/检测日期
     */
    @ApiModelProperty("采样/检测日期")
//    @TableField(value = "cyjcrq")
    private String cyjcrq;

    /**
     * 检测日期
     */
    @ApiModelProperty("检测日期")
//    @TableField(value = "jcrq")
    private String jcrq;

    /**
     * 结果项编码
     */
    @ApiModelProperty("结果项编码")
//    @TableField(value = "check_result_item_code")
    private String checkResultItemCode;

    /**
     * 结果
     */
    @ApiModelProperty("结果")
//    @TableField(value = "result")
    private String result;

    /**
     * 计量单位
     */
    @ApiModelProperty("计量单位")
//    @TableField(value = "unit")
    private String unit;

    /**
     * 接触限值
     */
    @ApiModelProperty("接触限值")
//    @TableField(value = "jcxz")
    private String jcxz;

    /**
     * 结论
     */
    @ApiModelProperty("结论")
//    @TableField(value = "conclusion")
    private Boolean conclusion;

}