package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Id;
import java.io.Serializable;

/**
 * @Author: DengJia
 * @Date: 2023/9/7
 * @Description: 万达仓对接 - 工作效能主表
 */
@Data
//@EqualsAndHashCode(callSuper = true)
//@Accessors(chain = true)
@TableName("wanda_zyws_work_effect")
public class WandaPullWorkEffect extends WandaPullBaseEntity implements Serializable {
    private static final long serialVersionUID = 8675617492311511626L;

    /**
     * id
     */
    @JacksonXmlProperty(localName = "ID")
    private Long id;

    /**
     * 行政区划ID
     */
    @JacksonXmlProperty(localName = "AREA_ID")
    private Long areaId;

    /**
     * 行政区划名称
     */
    @JacksonXmlProperty(localName = "AREA_NAME")
    private String areaName;

    /**
     * 行政区划级别 2地市 3区县
     */
    @JacksonXmlProperty(localName = "AREA_LEVEL")
    private Integer areaLevel;

    /**
     * 监督机构名称
     */
    @JacksonXmlProperty(localName = "SUPERVISER")
    private String superviser;

    /**
     * 平均企业接害劳动者数（公式：辖区接害员工总人数/辖区参与接害人数统计的企业总数<行政区划为地市时此字段有值>）
     */
    @JacksonXmlProperty(localName = "COM_AVG_PICKUP_COUNT")
    private Integer comAvgPickupCount;

    /**
     * 用人单位负责人和管理人员培训率（公式：其中已完成培训企业数/需画像企业数<行政区划为地市时此字段有值>）
     */
    @JacksonXmlProperty(localName = "COM_TRAINING_RATE")
    private String comTrainingRate;

    /**
     * 体检机构接入率
     */
    @JacksonXmlProperty(localName = "CHECK_ORG_RATE")
    private String checkOrgRate;

    /**
     * 排名（规则：有分数的，按分数排；没分数的，按风险化解率排；）
     */
    @JacksonXmlProperty(localName = "SORT")
    private Integer sort;

    /**
     * 画像完整率
     */
    @JacksonXmlProperty(localName = "PORTRAIT_FINISH_RATE")
    private String portraitFinishRate;

    /**
     * 风险化解率
     */
    @JacksonXmlProperty(localName = "RISK_DEAL_RATE")
    private String riskDealRate;

    /**
     * 画像完整分数
     */
    @JacksonXmlProperty(localName = "PORTRAIT_FINISH_SCORE")
    private String portraitFinishScore;

    /**
     * 风险化解分数
     */
    @JacksonXmlProperty(localName = "RISK_DEAL_SCORE")
    private String riskDealScore;

    @TableField(exist = false)
    private String createDateStr;
}
