package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * @description: 万达仓数据推送-培训记录表
 * @author 覃浩云 1770126791@qq.com
 * @version 1.0
 * @date 2023/3/21 11:28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("wanda_pull_training_data")
public class WandaPullTrainingData extends WandaPullBaseEntity implements Serializable {
    /**
     * 序号
     */
    @JacksonXmlProperty(localName = "ID")
    private String id;

    /**
     * 培训方式（1.线上；2.线下）
     */
    @JacksonXmlProperty(localName = "TRAIN_WAY")
    private Integer trainWay;

    /**
     * 培训地点（线下才需要填）
     */
    @JacksonXmlProperty(localName = "TRAIN_ADDRESS")
    private String trainAddress;

    /**
     * 培训项目名称
     */
    @JacksonXmlProperty(localName = "TRAIN_NAME")
    private String trainName;

    /**
     * 培训项目编号
     */
    @JacksonXmlProperty(localName = "TRAIN_NUM")
    private String trainNum;

    /**
     * 培训开始时间
     */
    @JacksonXmlProperty(localName = "TRAIN_DATE_BEGIN")
    private Date trainDateBegin;

    /**
     * 培训结束时间
     */
    @JacksonXmlProperty(localName = "TRAIN_DATE_END")
    private Date trainDateEnd;

    /**
     * 培训类型（1.初次培训 2.继续教育）
     */
    @JacksonXmlProperty(localName = "TRAIN_TYPE")
    private Integer trainType;

    /**
     * 培训项目区域
     */
    @JacksonXmlProperty(localName = "TRAIN_AREA")
    private String trainArea;

    /**
     * 培训组织单位
     */
    @JacksonXmlProperty(localName = "TRAIN_REGISTER")
    private String trainRegister;

    /**
     * 培训上报时间
     */
    @JacksonXmlProperty(localName = "TRAIN_REPORT_DATE")
    private Date trainReportDate;

    /**
     * 培训人员姓名
     */
    @JacksonXmlProperty(localName = "STAFF_NAME")
    private String staffName;

    /**
     * 培训人员身份证
     */
    @JacksonXmlProperty(localName = "ID_CARD")
    private String idCard;

    /**
     * 培训人员联系电话
     */
    @JacksonXmlProperty(localName = "STAFF_PHONE")
    private String staffPhone;

    /**
     * 培训人员所在单位
     */
    @JacksonXmlProperty(localName = "STAFF_COM_NAME")
    private String staffComName;

    /**
     * 培训人员所在单位信用代码
     */
    @JacksonXmlProperty(localName = "STAFF_COM_CODE")
    private String staffComCode;

    /**
     * 培训课时
     */
    @JacksonXmlProperty(localName = "TRAIN_HOUR")
    private String trainHour;

    /**
     * 考核结果
     */
    @JacksonXmlProperty(localName = "EXAM_RESULT")
    private String examResult;

    /**
     * 证书类型（12：企业主要负责人证书，13：管理人员证书）
     */
    @JacksonXmlProperty(localName = "CERT_TYPE")
    private Integer certType;

    /**
     * 证书编号
     */
    @JacksonXmlProperty(localName = "CERT_NUM")
    private String certNum;

    /**
     * 发证日期
     */
    @JacksonXmlProperty(localName = "CERT_CREATE_DATE")
    private Date certCreateDate;

    /**
     * 证书有效期
     */
    @JacksonXmlProperty(localName = "CERT_VALIDY_DATE")
    private Date certValidyDate;

    /**
     * 证书下载地址
     */
    @JacksonXmlProperty(localName = "CERT_DOWNLOAD_URL")
    private String certDownloadUrl;

    /**
     * 1.职业健康在线，2.杭州培训
     */
    @JacksonXmlProperty(localName = "DATA_SOURCE")
    private Integer dataSource;

    /**
     * 推送失败次数
     */
    private Integer pushFailNum;

    /**
     * 创建时间字符串（记录推送日志）
     */
    @TableField(exist = false)
    private String createDateStr;

}
