package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;

import javax.persistence.Transient;
import java.util.Date;

/**
 * 三同时数据对接表(WandaPullThreeTimeData)表实体类
 *
 * @author Supw
 * @since 2023-03-13 14:09:44
 */
@Data
public class WandaPullThreeTimeData implements java.io.Serializable{
    @JacksonXmlProperty(localName = "ID")
    private Long id;
    //赋码时间
    @JacksonXmlProperty(localName = "APPLY_DATE")
    private Date applyDate;
    //总建筑面积（平方米）
    @JacksonXmlProperty(localName = "BUILT_AREA")
    private String builtArea;
    //项目联系人
    @JacksonXmlProperty(localName = "CONTACT_NAME")
    private String contactName;
    //联系人电话
    @JacksonXmlProperty(localName = "CONTACT_TEL")
    private String contactTel;
    //项目所属行政区划代码
    @JacksonXmlProperty(localName = "DIVISION_CODE")
    private String divisionCode;
    //拟建成时间
    @JacksonXmlProperty(localName = "END_YEAR")
    private String endYear;
    //项目单位名称
    @JacksonXmlProperty(localName = "ENTERPRISE_NAME")
    private String enterpriseName;
    //国标行业
    @JacksonXmlProperty(localName = "INDUSTRY")
    private String industry;
    //国标行业名称
    @JacksonXmlProperty(localName = "INDUSTRY_NAME")
    private String industryName;
    //是否为子项目
    @JacksonXmlProperty(localName = "IS_CHILD_PROJECT")
    private String isChildProject;
    //总用地面积（亩）
    @JacksonXmlProperty(localName = "LAND_AREA")
    private String landArea;
    //证照编号
    @JacksonXmlProperty(localName = "LEREP_CERTNO")
    private String lerepCertno;
    //证照类型
    @JacksonXmlProperty(localName = "LEREP_CERTTYPE")
    private String lerepCerttype;
    //建设地点区划代码
    @JacksonXmlProperty(localName = "PLACE_CODE")
    private String placeCode;
    //建设地点详情
    @JacksonXmlProperty(localName = "PLACE_CODE_DETAIL")
    private String placeCodeDetail;
    //项目负责人
    @JacksonXmlProperty(localName = "PRINCIPAL_NAME")
    private String principalName;
    //负责人电话
    @JacksonXmlProperty(localName = "PRINCIPAL_TEL")
    private String principalTel;
    //项目代码
    @JacksonXmlProperty(localName = "PROJECT_CODE")
    private String projectCode;
    //项目名称
    @JacksonXmlProperty(localName = "PROJECT_NAME")
    private String projectName;
    //建设性质
    @JacksonXmlProperty(localName = "PROJECT_NATURE")
    private String projectNature;
    //项目类型
    @JacksonXmlProperty(localName = "PROJECT_TYPE")
    private String projectType;
    @JacksonXmlProperty(localName = "SCALE_CONTENT")
    private String scaleContent;
    //拟开工时间
    @JacksonXmlProperty(localName = "START_YEAR")
    private String startYear;
    //总投资额（万元）
    @JacksonXmlProperty(localName = "TOTAL_MONEY")
    private String totalMoney;
    //有效标识
    @JacksonXmlProperty(localName = "VALIDITY_FLAG")
    private String validityFlag;
    //0未处理， 1处理中， 2 已处理， 3推送失败
    private Integer isProc;
    //1新增数据， 0表示数据有修改 推送时需要
    private Boolean isAdd;
    //是否需要推送， 新增和修改后都需要重置为1 表示需要推送
    private Integer needPull;
    //最后推送时间
    private Date lastPullDate;
    //创建时间
    private Date createDate;
    @TableField(exist = false)
    private String createDateStr;
    //创建人
    private Long createBy;
    //最后修改时间
    private Date updateDate;
    //最后修改人ID
    private Long updateBy;
    //是否有效（0-无效，1-有效）
    private Boolean isValid;

    //推送次数（超过三次停止推送）
    private int pushNum;
}

