package cn.smarthse.services.wanda.api.entity;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;

import java.util.Date;

/**
 * 万达仓采集-员工体检记录主表(WandaPullPhyEmployee)表实体类
 *
 * @author Supw
 * @since 2023-03-03 09:38:31
 */
@Data
public class WandaPullPhyEmployee implements java.io.Serializable{
    //序号
    @JacksonXmlProperty(localName = "ID")
    private String id;
    //姓名
    @JacksonXmlProperty(localName = "TRUE_NAME")
    private String trueName;
    //证件类别
    @JacksonXmlProperty(localName = "ID_CARD_TYPE")
    private String idCardType;
    //证件号
    @JacksonXmlProperty(localName = "ID_CARD")
    private String idCard;
    //体检类别
    @JacksonXmlProperty(localName = "EXAMINATION_TYPE")
    private String examinationType;
    //性别
    @JacksonXmlProperty(localName = "SEX")
    private String sex;
    //年龄
    @JacksonXmlProperty(localName = "AGE")
    private Integer age;
    //接害工龄
    @JacksonXmlProperty(localName = "HURT_AGE")
    private String hurtAge;
    //统一社会信用代码
    @JacksonXmlProperty(localName = "U_CODE")
    private String uCode;
    //企业名称
    @JacksonXmlProperty(localName = "ENTERPRISE")
    private String enterprise;
    //所在行政区划
    @JacksonXmlProperty(localName = "AREA")
    private String area;
    //所在行政区划地址
    @JacksonXmlProperty(localName = "ADDRESS")
    private String address;
    //主检结论
    @JacksonXmlProperty(localName = "CHECK_RESULT_CODE")
    private String checkResultCode;
    //0未处理， 1处理中， 2 已处理， 3推送失败
    private Integer isProc;
    //1新增数据， 0表示数据有修改 推送时需要
    private Boolean isAdd;
    //是否需要推送， 新增和修改后都需要重置为1 表示需要推送
    private Integer needPull;
    //最后推送时间
    private Date lastPullDate;
    //创建时间
    private Date createDate;
    //创建人
    private Long createBy;
    //最后修改时间
    private Date updateDate;
    //最后修改人ID
    private Long updateBy;
    //是否有效（0-无效，1-有效）
    private Boolean isValid;

    //private String sourceId;
    private String  loadTime;

    //推送次数（超过三次停止推送）
    private int pushNum;
}

