package cn.smarthse.services.wanda.api.entity;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;

import java.util.Date;

/**
 * 万达仓数据采集-员工体检记录子表-体检危害因素(WandaPullPhyEmpHarzard)表实体类
 *
 * @author Supw
 * @since 2023-03-03 09:38:27
 */
@Data
public class WandaPullPhyEmpHarzard implements java.io.Serializable{
    //id
    @JacksonXmlProperty(localName = "ID")
    private String id;
    //员工体检主表id
    @JacksonXmlProperty(localName = "DATA_EMPLOYEE_ID")
    private String dataEmployeeId;
    //接触职业病危害因素名称
    @JacksonXmlProperty(localName = "HAZARD_NAME")
    private String hazardName;
    //结论
    @JacksonXmlProperty(localName = "RESULT")
    private String result;
    //0未处理， 1处理中， 2 已处理， 3推送失败
    private Integer isProc;
    //1新增数据， 0表示数据有修改 推送时需要
    private Boolean isAdd;
    //是否需要推送， 新增和修改后都需要重置为1 表示需要推送
    private Integer needPull;
    //最后推送时间
    private Date lastPullDate;
    //创建时间
    private Date createDate;
    //创建人
    private Long createBy;
    //最后修改时间
    private Date updateDate;
    //最后修改人ID
    private Long updateBy;
    //是否有效（0-无效，1-有效）
    private Boolean isValid;

    @JacksonXmlProperty(localName = "AREA")
    private String area;


    //private String sourceId;
    private String loadTime;

    private int pushNum;
}

