package cn.smarthse.services.wanda.api.entity;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 万达仓采集接口-企业子表-分类自查
 * @author 吴嘉诚
 * @date 2023/3/10
 * @desc
 */
public @Data
class WandaPullEnteSc extends WandaPullBaseEntity implements Serializable {

    @JacksonXmlProperty(localName = "ID")
    private String id;

    @JacksonXmlProperty(localName = "ENTERPRISE")
    private String enterprise;

    @JacksonXmlProperty(localName = "U_CODE")
    private String uCode;

    @JacksonXmlProperty(localName = "AREA")
    private String area;

    @JacksonXmlProperty(localName = "ADDRESS")
    private String address;

    @JacksonXmlProperty(localName = "BEFOR_WORK_CHECK")
    private String beforWorkCheck;      //上岗应检

    @JacksonXmlProperty(localName = "ON_WORK_CHECK")
    private String onWorkCheck;         //在岗应检

    @JacksonXmlProperty(localName = "QUIT_WORK_CHECK")
    private String quitWorkCheck;       //离岗应检

    @JacksonXmlProperty(localName = "BEFOR_WORK_CHECK2")
    private String beforWorkCheck2;     //上岗实检（依据企业上报）

    @JacksonXmlProperty(localName = "ON_WORK_CHECK2")
    private String onWorkCheck2;        //在岗实检（依据企业上报）

    @JacksonXmlProperty(localName = "QUIT_WORK_CHECK2")
    private String quitWorkCheck2;      //离岗实检（依据企业上报）

    @JacksonXmlProperty(localName = "STAFF_NUM")
    private Integer staffNum;            //职工总人数（含劳务派遣等）

    @JacksonXmlProperty(localName = "OCCU_DISEASE_NUM")
    private Integer occuDiseaseNum;      //接触职业病危害总人数（含劳务派遣等）

    @JacksonXmlProperty(localName = "MANAGE_LEVEL")
    private String manageLevel;         //职业卫生管理状况等级

    @JacksonXmlProperty(localName = "RISK_LEVEL")
    private String riskLevel;           //职业病危害风险等级

    @JacksonXmlProperty(localName = "OCCU_RISK_LEVEL")
    private String occuRiskLevel;      //行业职业病危害风险类别

    @JacksonXmlProperty(localName = "ALL_RISK_LEVEL")
    private String allRiskLevel;       //职业病危害综合风险分类

    @JacksonXmlProperty(localName = "LAST_CHECK_DATE")
    private Date lastCheckDate;       //最近体检时间

    @JacksonXmlProperty(localName = "LAST_MAIN_TRAIN_DATE")
    private Date lastMainTrainDate;      //主要负责人最近培训时间

    @JacksonXmlProperty(localName = "CHECK_DATE")
    private Date checkDate;             //最近检测时间

    @JacksonXmlProperty(localName = "ORG_NAME")
    private String orgName;             //检测机构名称

    @JacksonXmlProperty(localName = "DECLARE_YEAR")
    private String declareYear;         //最近申报时间

}
