package cn.smarthse.services.wanda.api.entity;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 万达仓采集-企业子表-处罚记录
 * @author 吴嘉诚
 * @date 2023/3/9
 * @desc
 */
public @Data
class WandaPullEntePunish extends WandaPullBaseEntity implements Serializable {

    @JacksonXmlProperty(localName = "ID")
    private String id;

    @JacksonXmlProperty(localName = "ENTERPRISE")
    private String enterprise;

    @JacksonXmlProperty(localName = "U_CODE")
    private String uCode;

    @JacksonXmlProperty(localName = "AREA")
    private String area;

    @JacksonXmlProperty(localName = "ADDRESS")
    private String address;

    @JacksonXmlProperty(localName = "SUPERVISION_ORG")
    private String supervisionOrg;

    @JacksonXmlProperty(localName = "RECORD_DATE")
    private Date recordDate;

    @JacksonXmlProperty(localName = "CASE_RESON")
    private String caseReson;

    @JacksonXmlProperty(localName = "SUPERVISION_PERSON1")
    private String supervisionPerson1;

    @JacksonXmlProperty(localName = "SUPERVISION_PERSON2")
    private String supervisionPerson2;

    @JacksonXmlProperty(localName = "CASE_TYPE")
    private String caseType;

    @JacksonXmlProperty(localName = "CASE_SOURCE")
    private String caseSource;

    @JacksonXmlProperty(localName = "CLOSED_DATE")
    private Date closedDate;

    @JacksonXmlProperty(localName = "PENALTY_DECISION")
    private String penaltyDecision;

    @JacksonXmlProperty(localName = "CLOSED_STATUS")
    private String closedStatus;

    @JacksonXmlProperty(localName = "RESULT")
    private String result;

    @JacksonXmlProperty(localName = "PUNISHMENT_BASIS")
    private String punishmentBasis;

}
