package cn.smarthse.services.wanda.api.entity;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 万达仓采集-检测主表
 * @author 吴嘉诚
 * @date 2023/3/7
 * @desc
 */
public @Data
class WandaPullDetect extends WandaPullBaseEntity implements Serializable {

    @JacksonXmlProperty(localName = "ID")
    private String id;

    @JacksonXmlProperty(localName = "ENTERPRISE")
    private String enterprise;  //企业名称

    @JacksonXmlProperty(localName = "U_CODE")
    private String uCode;   //统一社会信用代码

    @JacksonXmlProperty(localName = "AREA")
    private String area;    //所在行政区划

    @JacksonXmlProperty(localName = "ADDRESS")
    private String address;     //所在行政区划地址

    @JacksonXmlProperty(localName = "SERVICE_NAME")
    private String serviceName; //检测报告编号

    @JacksonXmlProperty(localName = "DETECT_DATE")
    private Date detectDate;    //检测时间

    @JacksonXmlProperty(localName = "REPORT_DATE")
    private Date reportDate;    //报告出具时间

    @JacksonXmlProperty(localName = "DETECT_REPORT_ORGA")
    private String detectReportOrga;    //服务机构名称

    @JacksonXmlProperty(localName = "DETECT_TYPE")
    private String detectType;  //检测类型

}
