package cn.smarthse.services.wanda.api.entity;

import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 吴嘉诚
 * @date 2023/3/7
 * @desc
 */
@ApiModel
public @Data
class WandaPullBaseEntity implements Serializable {

    //0未处理， 1处理中， 2 已处理， 3推送失败
    private Integer isProc;
    //1新增数据， 0表示数据有修改 推送时需要
    private Boolean isAdd;
    //是否需要推送， 新增和修改后都需要重置为1 表示需要推送
    private Integer needPull;
    //最后推送时间
    private Date lastPullDate;
    //创建时间
    private Date createDate;
    //创建人
    private Long createBy;
    //最后修改时间
    private Date updateDate;
    //最后修改人ID
    private Long updateBy;
    //是否有效（0-无效，1-有效）
    private Boolean isValid;

    private String sourceId;

    //推送次数（超过三次停止推送）
    private int pushNum;
}
