package cn.smarthse.services.wanda.api.entity;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import java.io.Serializable;


/**
 * <p>
 * 职业卫生-职业病鉴定
 * </p>
 *
 * @author zhangxu
 * @since 2022-10-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
//@TableName("wanda_odi_base")
@ApiModel(value="OdiBase对象", description="职业卫生-职业病鉴定")
public class WandaOdiBase extends WandaBaseData implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @ApiModelProperty(value = "	唯一标识")
    private Long id;

    @ApiModelProperty(value = "原主键___原主键")
    private String sourceId;

    @ApiModelProperty(value = "	姓名")
    private String name;

    @ApiModelProperty(value = "	身份证件类别")
    private String idcardType;

    @ApiModelProperty(value = "	身份证件号码")
    private String idcardCode;

    @ApiModelProperty(value = "	性别编码")
    private String sexCode;

    @ApiModelProperty(value = "	出生日期	")
    private String birthday;

    @ApiModelProperty(value = "	联系电话")
    private String telPhone;

    @ApiModelProperty(value = "	统一社会信用代码")
    private String creditCode;

    @ApiModelProperty(value = "	用人单位名称")
    private String employerName;

    @ApiModelProperty(value = "	经济类型编码")
    private String economicTypeCode;

    @ApiModelProperty(value = "	行业类别编码")
    private String industryCategoryCode;

    @ApiModelProperty(value = "	企业规模编码")
    private String enterpriseSizeCode;

    @ApiModelProperty(value = "	所属地区编码")
    private String areaCode;

    @ApiModelProperty(value = "	用人单位所在区名称")
    private String areaName;

    @ApiModelProperty(value = "	通讯地址	")
    private String address;

    @ApiModelProperty(value = "	邮政编码	")
    private String addressZipCode;

    @ApiModelProperty(value = "	用人单位联系人	")
    private String contactPerson;

    @ApiModelProperty(value = "	用人单位联系电话	")
    private String employerPhone;

    @ApiModelProperty(value = "	职业病名称	")
    private String diseaseCode;

    @ApiModelProperty(value = "	职业病种类")
    private String diseaseTypeCode;

    @ApiModelProperty(value = "	职业性化学中毒分类")
    private String occupationPoisoningTypeCode;

    @ApiModelProperty(value = "	诊断机构名称")
    private String zdjgmc;

    @ApiModelProperty(value = "	申请鉴定日期")
    private String applyIndentifyDate;

    @ApiModelProperty(value = "	鉴定日期	")
    private String identifyDate;

    @ApiModelProperty(value = "	鉴定类型")
    private String appraisalTypeCode;

    @ApiModelProperty(value = "	鉴定结论")
    private String firstIdentifyCompletionCode;

    @ApiModelProperty(value = "	鉴定机构名称")
    private String jdjgmc;

}
