package cn.smarthse.services.wanda.api.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;

/**
 * <p>
 * 职业卫生-职业健康档案
 * </p>
 *
 * @author zhoulj@smarthse.cn
 * @since 2022-10-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class WandaHealthCard extends WandaBaseData implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */

    @Id
    private Long id;

    /**
     * 数据源---唯一标识
     */
    private String sourceId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 身份证件类别
     */
    private String idcardType;

    /**
     * 身份证件号码
     */
    private String idcardCode;

    /**
     * 性别编码
     */
    private String sexCode;

    /**
     * 出生日期
     */
    private String birthday;

    /**
     * 联系电话
     */
    private String telPhone;

    /**
     * 紧急联系人
     */
    private String emergencyContact;

    /**
     * 紧急联系电话
     */
    private String contactInformation;

    /**
     * 车间
     */
    private String workshop;

    /**
     * 工种编码
     */
    private String jobCode;

    /**
     * 其他工种名称
     */
    private String otherJobName;

    /**
     * 放射工种编码
     */
    private String radiationType;

    /**
     * 婚姻状态编码
     */
    private String maritalStatusCode;

    /**
     * 劳动者工号
     */
    private String jobNumber;

    /**
     * 统一社会信用代码
     */
    private String creditCode;

    /**
     * 用人单位名称
     */
    private String employerName;

    /**
     * 经济类型编码
     */
    private String economicTypeCode;

    /**
     * 行业类别编码
     */
    private String industryCategoryCode;

    /**
     * 企业规模编码
     */
    private String enterpriseSizeCode;

    /**
     * 所属地区编码
     */
    private String areaCode;

    /**
     * 用人单位所在区名称
     */
    private String areaName;

    /**
     * 通讯地址
     */
    private String address;

    /**
     * 邮政编码
     */
    private String addressZipCode;

    /**
     * 用人单位联系人
     */
    private String contactPerson;

    /**
     * 用人单位联系电话
     */
    private String employerPhone;

    /**
     * 用工单位统一社会信用代码
     */
    private String creditCodeEmployer;

    /**
     * 用工单位名称
     */
    private String employerNameEmployer;

    /**
     * 用工单位企业（经济）类型代码
     */
    private String economicTypeCodeEmployer;

    /**
     * 用工单位行业类别代码
     */
    private String ygdwhylbdm;

    /**
     * 用工单位企业规模代码
     */
    private String enterpriseSizeCodeEmployer;

    /**
     * 用工单位所属地区代码
     */
    private String areaCodeEmployer;

    /**
     * 用工单位所在区全名称
     */
    private String areaNameEmployer;

    /**
     * 体检机构编码
     */
    private String orgCode;

    /**
     * 体检机构名称
     */
    private String orgName;

    /**
     * 职业健康档案编号
     */
    private String reportCode;

    /**
     * 职业健康档案类别
     */
    private String zyjkdalb;

    /**
     * 总工龄年
     */
    private String seniorityYear;

    /**
     * 总工龄月
     */
    private String seniorityMonth;

    /**
     * 接触工龄年
     */
    private String exposureYear;

    /**
     * 接触工龄月
     */
    private String exposureMonth;

    /**
     * 检查类型
     */
    private String checkType;

    /**
     * 体检类型编码
     */
    private String bodyCheckType;

    /**
     * 复检对应上次的职业健康档案编号
     */
    private String previousCardId;

    /**
     * 体检日期
     */
    private String checkTime;

    /**
     * 填表人名称
     */
    private String writePerson;

    /**
     * 填表人电话
     */
    private String writePersonTel;

    /**
     * 报告出具日期
     */
    private String writeDate;

    /**
     * 主检结论
     */
    private String checkResultCode;

    /**
     * 主检建议
     */
    private String suggest;

    /**
     * 主检医生
     */
    private String zjys;

    /**
     * 监测类型代码
     */
    private String monitorTypeCode;

    /**
     * 报告单位名称
     */
    private String reportUnit;

    /**
     * 报告人姓名
     */
    private String reportPerson;

    /**
     * 报告人联系电话
     */
    private String reportPersonTel;

    /**
     * 备注
     */
    private String remark;

    /**
     * 接触的危害因素编码
     */
    private String contactHazardCode;

    /**
     * 其他危害因素具体名称
     */
    private String contactOtherHazardName;

    /**
     * 危害因素编码
     */
    private String tjwhysbm;

    /**
     * 其他危害因素具体名称
     */
    private String otherHazardName;

    /**
     * 开始接害日期
     */
    private String hazardStartDate;

    /**
     * 接触所监测危害因素工龄年
     */
    private String hazardYear;

    /**
     * 接触所监测危害因素工龄月
     */
    private String hazardMonth;

    /**
     * 体检项目编号
     */
    private String itemId;

    /**
     * 其他项目名称
     */
    private String qttjxmmc;

    /**
     * 项目组合名称
     */
    private String itemGroupName;

    /**
     * 检查科室
     */
    private String department;

    /**
     * 检查项目结果
     */
    private String jcxmjg;

    /**
     * 检查结果类别编码
     */
    private String type;

    /**
     * 计量单位
     */
    private String unit;

    /**
     * 参考范围最大值
     */
    private String max;

    /**
     * 参考范围最小值
     */
    private String min;

    /**
     * 符号编码
     */
    private String characterCode;

    /**
     * 检查项目结论
     */
    private String jcxmjl;

    /**
     * 合格标记
     */
    private String mark;

    /**
     * 检查日期
     */
    private String checkDate;

    /**
     * 检查医生
     */
    private String checkDoctor;

    /**
     * 危害因素编码
     */
    private String hazardCode;

    /**
     * 体检结论编码
     */
    private String conclusion;

    /**
     * 需复查的检查项目编码
     */
    private String repeatItemId;

    /**
     * 需复查的其他检查项目名称
     */
    private String otherItemName;

    /**
     * 职业禁忌证编码
     */
    private String cdtId;

    /**
     * 疑似职业病编码
     */
    private String sptId;

    /**
     * 其他疾病名称
     */
    private String otherDisease;


    private Byte isConverted;
    private Byte isRepeated;

    @Transient
    private String reason;
    @Transient
    private String sysReference;
    @Transient
    private String sysReferenceCompanyName;
    @Transient
    private String sysReferenceCreditCode;

}
