package cn.smarthse.services.wanda.api.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import java.io.Serializable;

/**
 * 万达体检项目
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class WandaHcItems extends WandaBaseData implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */

    @Id
    private Long id;

    /**
     * 原id
     */
    private String sourceId;

    /**
     * 体检主表的ID
     */
    private String cardId;

    /**
     * 体检项目编号
     */
    private String itemId;

    /**
     * 其他项目名称
     */
    private String qttjxmmc;

    /**
     * 项目组合名称
     */
    private String itemGroupName;

    /**
     * 检查科室
     */
    private String department;

    /**
     * 检查项目结果
     */
    private String jcxmjg;

    /**
     * 检查结果类别编码
     */
    private String type;

    /**
     * 计量单位
     */
    private String unit;

    /**
     * 参考范围最大值
     */
    private String max;

    /**
     *参考范围最小值
     */
    private String min;

    /**
     *符号编码
     */
    private String characterCode;

    /**
     *检查项目结论
     */
    private String jcxmjl;

    /**
     *合格标记
     */
    private String mark;

    /**
     *检查日期
     */
    private String checkDate;

    /**
     * 检查医生
     */
    private String checkDoctor;

}
