package cn.smarthse.services.wanda.api.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import java.io.Serializable;

/**
 * 万达体检危害因素
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class WandaHcFactors extends WandaBaseData implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */

    @Id
    private Long id;

    /**
     * 原id
     */
    private String sourceId;

    /**
     * 体检主表的ID
     */
    private String cardId;

    /**
     * 其他危害因素具体名称
     */
    private String otherHazardName;

    /**
     * 接触所监测危害因素工龄年
     */
    private String hazardYear;

    /**
     * 接触所监测危害因素工龄月
     */
    private String hazardMonth;

    /**
     * 危害因素编码
     */
    private String hazardCode;

}
