package cn.smarthse.services.wanda.api.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import java.io.Serializable;

/**
 * 万达体检诊断结论
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class WandaHcDiags extends WandaBaseData implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */

    @Id
    private Long id;

    /**
     * 原id
     */
    private String sourceId;

    /**
     * 体检主表的ID
     */
    private String cardId;

    /**
     * 危害因素编码
     */
    private String hazardCode;

    /**
     * 体检结论编码
     */
    private String conclusion;

    /**
     * 职业禁忌证编码
     */
    private String cotId;

    /**
     * 疑似职业病编码
     */
    private String sptId;

    /**
     * 其他疾病名称
     */
    private String otherDisease;

}
