package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Transient;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 检测退回推送记录表
 * </p>
 *
 * @author author
 * @since 2023-05-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="WandaZywsCheckBackPushLog对象", description="检测退回推送记录表")
@TableName(value = "wanda_zyws_check_back_push_log")
public class WandaCheckBackPushLog implements Serializable {

    private static final long serialVersionUID = -20726842229692916L;


    /**
     * id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @TableField(value = "id")
    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 推送危害因素检测ID
     */
    @TableField(value = "check_id")
    @ApiModelProperty(value = "推送危害因素检测ID")
    private String checkId;

    /**
     * 数据在我们这里的流转状态
     */
    @TableField(value = "deal_state")
    @ApiModelProperty(value = "数据在我们这里的流转状态")
    private String dealState;

    /**
     * 退回原因类型
     */
    @TableField(value = "type")
    @ApiModelProperty(value = "退回原因类型")
    private Integer type;

    /**
     * 退回原因
     */
    @TableField(value = "reason")
    @ApiModelProperty(value = "退回原因")
    private String reason;

    /**
     * 状态（1、已推送 2、推送失败）
     * 搜索传的状态（0、未推送 1、已推送 2、推送失败    4搜索时用表示除了已推送的）
     */
    @TableField(value = "status")
    @ApiModelProperty(value = "状态（1、已推送 2、推送失败）")
    private Integer status;

    /**
     * 推送时间
     */
    @TableField(value = "push_date")
    @ApiModelProperty(value = "推送时间")
    private Date pushDate;

    /**
     * 业务id
     */
    @TableField(value = "source_id")
    @ApiModelProperty(value = "业务id")
    private Long sourceId;

    /**
     * 创建时间（检测主表的loadTime）
     */
    @TableField(value = "create_date")
    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    /**
     * 创建人
     */
    @TableField(value = "create_by")
    @ApiModelProperty(value = "创建人")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @TableField(value = "update_date")
    @ApiModelProperty(value = "最后修改时间")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @TableField(value = "update_by")
    @ApiModelProperty(value = "最后修改人ID")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @TableField(value = "is_valid")
    @ApiModelProperty(value = "是否有效（0-无效，1-有效）")
    private Boolean isValid;

    @TableField(exist = false)
    private List<String> checkIdList;
}
