package cn.smarthse.services.wanda.api.entity;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 万达仓推送-职业卫生-疑似职业病 (BIZ_037_ZYWS_SOD_BASE)
 *
 * @author Supw
 * @since 2022-10-31 11:38:23
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SodBase2Wanda extends WandaBaseData implements java.io.Serializable {

    private static final long serialVersionUID = 1L;

    @JacksonXmlProperty(localName = "ID")
    private String id;

    //姓名
    @JacksonXmlProperty(localName = "NAME")
    private String name;

    //身份证件类别
    @JacksonXmlProperty(localName = "IDCARD_TYPE")
    private String idcardType;

    //身份证件号码
    @JacksonXmlProperty(localName = "IDCARD_CODE")
    private String idcardCode;

    //性别编码
    @JacksonXmlProperty(localName = "SEX_CODE")
    private String sexCode;

    //出生日期
    @JacksonXmlProperty(localName = "BIRTHDAY")
    private String birthday;

    //联系电话
    @JacksonXmlProperty(localName = "TEL_PHONE")
    private String telPhone;

    //统一社会信用代码
    @JacksonXmlProperty(localName = "CREDIT_CODE")
    private String creditCode;

    //用人单位名称
    @JacksonXmlProperty(localName = "EMPLOYER_NAME")
    private String employerName;

    //经济类型编码
    @JacksonXmlProperty(localName = "ECONOMIC_TYPE_CODE")
    private String economicTypeCode;

    //行业类别编码
    @JacksonXmlProperty(localName = "INDUSTRY_CATEGORY_CODE")
    private String industryCategoryCode;

    //企业规模编码
    @JacksonXmlProperty(localName = "ENTERPRISE_SIZE_CODE")
    private String enterpriseSizeCode;

    //所属地区编码
    @JacksonXmlProperty(localName = "AREA_CODE")
    private String areaCode;

    //用人单位所在区名称
    @JacksonXmlProperty(localName = "AREA_NAME")
    private String areaName;

    //通讯地址
    @JacksonXmlProperty(localName = "ADDRESS")
    private String address;

    //邮政编码
    @JacksonXmlProperty(localName = "ADDRESS_ZIP_CODE")
    private String addressZipCode;

    //用人单位联系人
    @JacksonXmlProperty(localName = "CONTACT_PERSON")
    private String contactPerson;

    //用人单位联系电话
    @JacksonXmlProperty(localName = "EMPLOYER_PHONE")
    private String employerPhone;

    //用工单位统一社会信用代码
    @JacksonXmlProperty(localName = "CREDIT_CODE_EMPLOYER")
    private String creditCodeEmployer;

    //用工单位名称
    @JacksonXmlProperty(localName = "EMPLOYER_NAME_EMPLOYER")
    private String employerNameEmployer;

    //用工单位企业（经济）类型代码
    @JacksonXmlProperty(localName = "ECONOMIC_TYPE_CODE_EMPLOYER")
    private String economicTypeCodeEmployer;

    //用工单位行业类别代码
    @JacksonXmlProperty(localName = "YGDWHYLBDM")
    private String ygdwhylbdm;

    //用工单位企业规模代码
    @JacksonXmlProperty(localName = "ENTERPRISE_SIZE_CODE_EMPLOYER")
    private String enterpriseSizeCodeEmployer;

    //用工单位所属地区代码
    @JacksonXmlProperty(localName = "AREA_CODE_EMPLOYER")
    private String areaCodeEmployer;

    //用工单位所在区全名称
    @JacksonXmlProperty(localName = "AREA_NAME_EMPLOYER")
    private String areaNameEmployer;

    //接触的职业病危害因素
    @JacksonXmlProperty(localName = "HAZARD_CODE")
    private String hazardCode;

    @JacksonXmlProperty(localName = "OTHER_HAZARD_NAME")
    private String otherHazardName;

    //接害开始日期
    @JacksonXmlProperty(localName = "HAZARD_START_DATE")
    private String hazardStartDate;

    //接触危害因素工龄月
    @JacksonXmlProperty(localName = "HAZARD_YEAR")
    private String hazardYear;

    //疑似职业病种类
    @JacksonXmlProperty(localName = "DISEASE_TYPE_CODE")
    private String diseaseTypeCode;

    //疑似职业病名称
    @JacksonXmlProperty(localName = "DISEASE_CODE")
    private String diseaseCode;

    //发现日期
    @JacksonXmlProperty(localName = "DIAGNOSE_DATE")
    private String diagnoseDate;

    //信息来源
    @JacksonXmlProperty(localName = "INFOR_SOURCE_CODE")
    private String inforSourceCode;

    //发现单位
    @JacksonXmlProperty(localName = "DIAGNOSE_UNIT_NAME")
    private String diagnoseUnitName;

    //发现单位负责人
    @JacksonXmlProperty(localName = "DIAGNOSE_PERSON")
    private String diagnosePerson;

    //报告人姓名
    @JacksonXmlProperty(localName = "REPORT_PERSON")
    private String reportPerson;

    //联系电话
    @JacksonXmlProperty(localName = "REPORT_PERSON_TEL")
    private String reportPersonTel;

    //报告日期
    @JacksonXmlProperty(localName = "REPORT_DATE")
    private String reportDate;

    //报告单位
    @JacksonXmlProperty(localName = "REPORT_UNIT")
    private String reportUnit;

}

