package cn.smarthse.services.wanda.api.entity;

import lombok.Data;

import javax.persistence.Id;

/**
 * 职业卫生-疑似职业病(SodBase)表实体类
 *
 * @author Supw
 * @since 2022-10-31 11:38:23
 */
@Data
public class SodBase extends WandaBaseData implements java.io.Serializable{

    private static final long serialVersionUID = 1L;
    //唯一标识
    @Id
    private Long id;
    /**
     * 数据源---唯一标识
     */
    private String sourceId;
    //姓名
    private String name;
    //身份证件类别
    private String idcardType;
    //身份证件号码
    private String idcardCode;
    //性别编码
    private String sexCode;
    //出生日期
    private String birthday;
    //联系电话
    private String telPhone;
    //统一社会信用代码
    private String creditCode;
    //用人单位名称
    private String employerName;
    //经济类型编码
    private String economicTypeCode;
    //行业类别编码
    private String industryCategoryCode;
    //企业规模编码
    private String enterpriseSizeCode;
    //所属地区编码
    private String areaCode;
    //用人单位所在区名称
    private String areaName;
    //通讯地址
    private String address;
    //邮政编码
    private String addressZipCode;
    //用人单位联系人
    private String contactPerson;
    //用人单位联系电话
    private String employerPhone;
    //用工单位统一社会信用代码
    private String creditCodeEmployer;
    //用工单位名称
    private String employerNameEmployer;
    //用工单位企业（经济）类型代码
    private String economicTypeCodeEmployer;
    //用工单位行业类别代码
    private String ygdwhylbdm;
    //用工单位企业规模代码
    private String enterpriseSizeCodeEmployer;
    //用工单位所属地区代码
    private String areaCodeEmployer;
    //用工单位所在区全名称
    private String areaNameEmployer;
    //接触的职业病危害因素
    private String hazardCode;
    
    private String otherHazardName;
    //接害开始日期
    private String hazardStartDate;
    //接触危害因素工龄月
    private String hazardYear;
    //疑似职业病种类
    private String diseaseTypeCode;
    //疑似职业病名称
    private String diseaseCode;
    //发现日期
    private String diagnoseDate;
    //信息来源
    private String inforSourceCode;
    //发现单位
    private String diagnoseUnitName;
    //发现单位负责人
    private String diagnosePerson;
    //报告人姓名
    private String reportPerson;
    //联系电话
    private String reportPersonTel;
    //报告日期
    private String reportDate;
    //报告单位
    private String reportUnit;

}

