package cn.smarthse.services.wanda.api.entity;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * 万达仓推送-职业卫生-职业病鉴定 (BIZ_037_ZYWS_ODI_BASE)
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/12/7 15:42
 */
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public @Data
class OdiBase2Wanda extends WandaBaseData implements Serializable {

    @JacksonXmlProperty(localName = "ID")
    private String id;

    /**
     * 姓名
     */
    @JacksonXmlProperty(localName = "NAME")
    private String name;

    /**
     * 身份证件类别
     */
    @JacksonXmlProperty(localName = "IDCARD_TYPE")
    private String idcardType;

    /**
     * 身份证件号码
     */
    @JacksonXmlProperty(localName = "IDCARD_CODE")
    private String idcardCode;

    /**
     * 性别编码
     */
    @JacksonXmlProperty(localName = "SEX_CODE")
    private String sexCode;

    /**
     * 出生日期
     */
    @JacksonXmlProperty(localName = "BIRTHDAY")
    private Date birthday;

    /**
     * 联系电话
     */
    @JacksonXmlProperty(localName = "TEL_PHONE")
    private String telPhone;

    /**
     * 统一社会信用代码
     */
    @JacksonXmlProperty(localName = "CREDIT_CODE")
    private String creditCode;

    /**
     * 用人单位名称
     */
    @JacksonXmlProperty(localName = "EMPLOYER_NAME")
    private String employerName;

    /**
     * 经济类型编码
     */
    @JacksonXmlProperty(localName = "ECONOMIC_TYPE_CODE")
    private String economicTypeCode;

    /**
     * 行业类别编码
     */
    @JacksonXmlProperty(localName = "INDUSTRY_CATEGORY_CODE")
    private String industryCategoryCode;

    /**
     * 企业规模编码
     */
    @JacksonXmlProperty(localName = "ENTERPRISE_SIZE_CODE")
    private String enterpriseSizeCode;

    /**
     * 所属地区编码
     */
    @JacksonXmlProperty(localName = "AREA_CODE")
    private String areaCode;

    /**
     * 用人单位所在区名称
     */
    @JacksonXmlProperty(localName = "AREA_NAME")
    private String areaName;

    /**
     * 通讯地址
     */
    @JacksonXmlProperty(localName = "ADDRESS")
    private String address;

    /**
     * 邮政编码
     */
    @JacksonXmlProperty(localName = "ADDRESS_ZIP_CODE")
    private String addressZipCode;

    /**
     * 用人单位联系人
     */
    @JacksonXmlProperty(localName = "CONTACT_PERSON")
    private String contactPerson;

    /**
     * 用人单位联系电话
     */
    @JacksonXmlProperty(localName = "EMPLOYER_PHONE")
    private String employerPhone;

    /**
     * 职业病名称
     */
    @JacksonXmlProperty(localName = "DISEASE_CODE")
    private String diseaseCode;

    /**
     * 职业病种类
     */
    @JacksonXmlProperty(localName = "DISEASE_TYPE_CODE")
    private String diseaseTypeCode;

    /**
     * 职业性化学中毒分类
     */
    @JacksonXmlProperty(localName = "OCCUPATION_POISONING_TYPE_CODE")
    private String occupationPoisoningTypeCode;

    /**
     * 诊断机构名称
     */
    @JacksonXmlProperty(localName = "ZDJGMC")
    private String zdjgmc;

    /**
     * 申请鉴定日期
     */
    @JacksonXmlProperty(localName = "APPLY_INDENTIFY_DATE")
    private Date applyIndentifyDate;

    /**
     * 鉴定日期
     */
    @JacksonXmlProperty(localName = "IDENTIFY_DATE")
    private Date identifyDate;

    /**
     * 鉴定类型
     */
    @JacksonXmlProperty(localName = "APPRAISAL_TYPE_CODE")
    private String appraisalTypeCode;

    /**
     * 鉴定结论
     */
    @JacksonXmlProperty(localName = "FIRST_IDENTIFY_COMPLETION_CODE")
    private String firstIdentifyCompletionCode;

    /**
     * 鉴定机构名称
     */
    @JacksonXmlProperty(localName = "JDJGMC")
    private String jdjgmc;

    // ----------------------------------------------------------------

    // 尘肺病1期日期
    private String cfb1;
    // 尘肺病2期日期
    private String cfb2;
    // 尘肺病3期日期
    private String cfb3;

    // 鉴定结论(与诊断结论是否一致)
    private String sameAsDiagnosis;
    // 鉴定结论(与首次鉴定结论是否一致)
    private String sameAsFirstAppraisal;
    // 鉴定信息-职业病-名称
    private String appraisalOccupationalName;
    // 鉴定信息-职业病-类型
    private String appraisalOccupationalType;
    // 鉴定信息-尘肺1期日期
    private Date appraisalCf1Date;
    // 鉴定信息-尘肺2期日期
    private Date appraisalCf2Date;
    // 鉴定信息-尘肺3期日期
    private Date appraisalCf3Date;


    public String getDiseaseTypeCode() {

        if (StringUtils.isNotEmpty(this.appraisalOccupationalType) && !this.appraisalOccupationalType.equals("--")) {
            this.diseaseTypeCode = this.appraisalOccupationalType;
        }

        if (StringUtils.isEmpty(this.diseaseTypeCode) || this.diseaseTypeCode.equals("--")) {
            return null;
        }

        if (this.appraisalCf3Date != null) {
            return this.diseaseTypeCode.concat("_三期");
        } else if (this.appraisalCf2Date != null) {
            return this.diseaseTypeCode.concat("_二期");
        } else if (this.appraisalCf1Date != null) {
            return this.diseaseTypeCode.concat("_一期");
        } else if (this.cfb3 != null) {
            return this.diseaseTypeCode.concat("_三期");
        } else if (this.cfb2 != null) {
            return this.diseaseTypeCode.concat("_二期");
        } else if (this.cfb1 != null) {
            return this.diseaseTypeCode.concat("_一期");
        }

        return diseaseTypeCode;
    }

    public String getDiseaseCode() {

        if (StringUtils.isNotEmpty(this.appraisalOccupationalName) && !this.appraisalOccupationalName.equals("--")) {
            this.diseaseCode = this.appraisalOccupationalName;
        }

        return diseaseCode;
    }

    public Date getIdentifyDate() {
        if (this.appraisalCf3Date != null) {
            return this.appraisalCf3Date;
        } else if (this.appraisalCf2Date != null) {
            return this.appraisalCf2Date;
        } else if (this.appraisalCf1Date != null) {
            return this.appraisalCf1Date;
        }
        return this.identifyDate;
    }

}
