package cn.smarthse.services.wanda.api.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

/**
 * 万达仓推送-职业卫生-职业病病例 (BIZ_037_ZYWS_ODC_BASE)
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/12/7 15:42
 */
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Data
public class OdcBase2Wanda extends WandaBaseData implements Serializable {

    @JacksonXmlProperty(localName = "ID")
    private String id;

    /**
     * 姓名
     */
    @JacksonXmlProperty(localName = "NAME")
    private String name;

    /**
     * 身份证件类别
     */
    @JacksonXmlProperty(localName = "IDCARD_TYPE")
    private String idcardType;

    /**
     * 身份证件号码
     */
    @JacksonXmlProperty(localName = "IDCARD_CODE")
    private String idcardCode;

    /**
     * 性别编码
     */
    @JacksonXmlProperty(localName = "SEX_CODE")
    private String sexCode;

    /**
     * 出生日期
     */
    @JacksonXmlProperty(localName = "BIRTHDAY")
    private Date birthday;

    /**
     * 联系电话
     */
    @JacksonXmlProperty(localName = "TEL_PHONE")
    private String telPhone;

    /**
     * 统一社会信用代码
     */
    @JacksonXmlProperty(localName = "CREDIT_CODE")
    private String creditCode;

    /**
     * 用人单位名称
     */
    @JacksonXmlProperty(localName = "EMPLOYER_NAME")
    private String employerName;

    /**
     * 经济类型编码
     */
    @JacksonXmlProperty(localName = "ECONOMIC_TYPE_CODE")
    private String economicTypeCode;

    /**
     * 行业类别编码
     */
    @JacksonXmlProperty(localName = "INDUSTRY_CATEGORY_CODE")
    private String industryCategoryCode;

    /**
     * 企业规模编码
     */
    @JacksonXmlProperty(localName = "ENTERPRISE_SIZE_CODE")
    private String enterpriseSizeCode;

    /**
     * 所属地区编码
     */
    @JacksonXmlProperty(localName = "AREA_CODE")
    private String areaCode;

    /**
     * 用人单位所在区名称
     */
    @JacksonXmlProperty(localName = "AREA_NAME")
    private String areaName;

    /**
     * 通讯地址
     */
    @JacksonXmlProperty(localName = "ADDRESS")
    private String address;

    /**
     * 邮政编码
     */
    @JacksonXmlProperty(localName = "ADDRESS_ZIP_CODE")
    private String addressZipCode;

    /**
     * 用人单位联系人
     */
    @JacksonXmlProperty(localName = "CONTACT_PERSON")
    private String contactPerson;

    /**
     * 用人单位联系电话
     */
    @JacksonXmlProperty(localName = "EMPLOYER_PHONE")
    private String employerPhone;

    /**
     * 用工单位统一社会信用代码
     */
    @JacksonXmlProperty(localName = "CREDIT_CODE_EMPLOYER")
    private String creditCodeEmployer;

    /**
     * 用工单位名称
     */
    @JacksonXmlProperty(localName = "EMPLOYER_NAME_EMPLOYER")
    private String employerNameEmployer;

    /**
     * 用工单位企业（经济）类型代码
     */
    @JacksonXmlProperty(localName = "ECONOMIC_TYPE_CODE_EMPLOYER")
    private String economicTypeCodeEmployer;

    /**
     * 用工单位行业类别代码
     */
    @JacksonXmlProperty(localName = "YGDWHYLBDM")
    private String ygdwhylbdm;

    /**
     * 用工单位企业规模代码
     */
    @JacksonXmlProperty(localName = "ENTERPRISE_SIZE_CODE_EMPLOYER")
    private String enterpriseSizeCodeEmployer;

    /**
     * 用工单位所属地区代码
     */
    @JacksonXmlProperty(localName = "AREA_CODE_EMPLOYER")
    private String areaCodeEmployer;

    /**
     * 用工单位所在区全名称
     */
    @JacksonXmlProperty(localName = "AREA_NAME_EMPLOYER")
    private String areaNameEmployer;

    /**
     * 诊断登记日期
     */
    @JacksonXmlProperty(localName = "APPLY_DIAGNOSE_DATE")
    private Date applyDiagnoseDate;

    /**
     * 接触的职业病危害因素
     */
    @JacksonXmlProperty(localName = "HAZARD_CODE")
    private String hazardCode;

    /**
     * 接害开始日期
     */
    @JacksonXmlProperty(localName = "HAZARD_START_DATE")
    private Date hazardStartDate;

    /**
     * 实际接触危害因素工龄年
     */
    @JacksonXmlProperty(localName = "HAZARD_YEAR")
    private String hazardYear;

    /**
     * 实际接触危害因素工龄月
     */
    @JacksonXmlProperty(localName = "HAZARD_MONTH")
    private String hazardMonth;

    /**
     * 职业病种类
     */
    @JacksonXmlProperty(localName = "DISEASE_TYPE_CODE")
    private String diseaseTypeCode;

    /**
     * 职业病名称
     */
    @JacksonXmlProperty(localName = "DISEASE_CODE")
    private String diseaseCode;

    /**
     * 诊断日期
     */
    @JacksonXmlProperty(localName = "DIAGNOSE_DATE")
    private Date diagnoseDate;

    /**
     * 死亡日期
     */
    @JacksonXmlProperty(localName = "DIE_DATE")
    private Date dieDate;

    /**
     * 死亡原因
     */
    @JacksonXmlProperty(localName = "DIE_REASON_CODE")
    private String dieReasonCode;

    /**
     * 组织诊断单位名称
     */
    @JacksonXmlProperty(localName = "ZDDWMC")
    private String zddwmc;

    /**
     * 诊断单位负责人
     */
    @JacksonXmlProperty(localName = "DIAGNOSE_PERSON")
    private String diagnosePerson;

    /**
     * 诊断医师单位
     */
    @JacksonXmlProperty(localName = "ZDYSDW")
    private String zdysdw;

    /**
     * 报告人姓名
     */
    @JacksonXmlProperty(localName = "REPORT_PERSON")
    private String reportPerson;

    /**
     * 联系电话
     */
    @JacksonXmlProperty(localName = "REPORT_PERSON_TEL")
    private String reportPersonTel;

    /**
     * 报告日期
     */
    @JacksonXmlProperty(localName = "REPORT_DATE")
    private Date reportDate;

    /**
     * 报告单位
     */
    @JacksonXmlProperty(localName = "REPORT_UNIT")
    private String reportUnit;

    // ---------------------------------------------------------------------------------------------------------------//
    // 其他职业病具体名称
    private String otherOccupationalName;

    // 尘肺病1期日期
    private Date cfb1date;
    // 尘肺病2期日期
    private Date cfb2date;
    // 尘肺病3期日期
    private Date cfb3date;

    // 鉴定信息-职业病-名称
    private String appraisalZybName;
    // 鉴定信息-职业病-类型
    private String appraisalZybType;
    // 鉴定信息-尘肺1期日期
    private Date appraisalCf1Date;
    // 鉴定信息-尘肺2期日期
    private Date appraisalCf2Date;
    // 鉴定信息-尘肺3期日期
    private Date appraisalCf3Date;

    public String getDiseaseTypeCode() {

        if (StringUtils.isNotEmpty(this.appraisalZybType) && !this.appraisalZybType.equals("--")) {
            this.diseaseTypeCode = this.appraisalZybType;
        }

        if (StringUtils.isEmpty(this.diseaseTypeCode) || this.diseaseTypeCode.equals("--")) {
            return null;
        }

        if (this.appraisalCf3Date != null) {
            return this.diseaseTypeCode.concat("_三期");
        } else if (this.appraisalCf2Date != null) {
            return this.diseaseTypeCode.concat("_二期");
        } else if (this.appraisalCf1Date != null) {
            return this.diseaseTypeCode.concat("_一期");
        } else if (this.cfb3date != null) {
            return this.diseaseTypeCode.concat("_三期");
        } else if (this.cfb2date != null) {
            return this.diseaseTypeCode.concat("_二期");
        } else if (this.cfb1date != null) {
            return this.diseaseTypeCode.concat("_一期");
        }

        return diseaseTypeCode;
    }

    public String getDiseaseCode() {

        if (StringUtils.isNotEmpty(this.appraisalZybName) && !this.appraisalZybName.equals("--")) {
            this.diseaseCode = this.appraisalZybName;
        }

        if (StringUtils.isNotEmpty(this.otherOccupationalName) && !this.otherOccupationalName.equals("--")) {
            if (StringUtils.isEmpty(this.diseaseCode)) {
                return "_" + this.otherOccupationalName;
            } else {
                return this.diseaseCode.concat("_" + this.otherOccupationalName);
            }
        }
        return diseaseCode;
    }

    public Date getDiagnoseDate() {
        if (this.appraisalCf3Date != null) {
            return this.appraisalCf3Date;
        } else if (this.appraisalCf2Date != null) {
            return this.appraisalCf2Date;
        } else if (this.appraisalCf1Date != null) {
            return this.appraisalCf1Date;
        }
        return diagnoseDate;
    }
}
