package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * @Database: company_unresolved_risk_work
 */

@Data
@TableName("chuangde_company_unresolved_risk_work")
public class CompanyUnresolvedRiskWork  implements Serializable{

	private static final Long serialVersionUID = -1972809598063337469L;

	/**
	 * id
	 */
  	@Id
	@Column(name = "id")
	private Long id;

    /**
     * 工作区状态，1为草稿，2为待确认，3为已退回，4为已确认
     */
    @Column(name = "push_status")
    private Integer pushStatus;

    /**
     * 风险规则 ID
     */
    @Column(name = "rule_id")
    private String ruleId;

    /**
     * 监督单位行政区划
     */
    @Column(name = "supervision_area_id")
    private Long supervisionAreaId;

    /**
     * 监督单位
     */
    @Column(name = "supervision_unit")
    private Long supervisionUnit;

    /**
     * 佐证材料限制一个
     */
    @Column(name = "push_file")
    private Long pushFile;

    /**
     * 提交时间
     */
    @Column(name = "submission_time")
    private Date submissionTime;

	/**
	 * 创建人
	 */
  	@Column(name = "create_by")
	private Long createBy;

	/**
	 * 创建时间
	 */
  	@Column(name = "create_date")
	private Date createDate;

	/**
	 * 最后修改人ID
	 */
  	@Column(name = "update_by")
	private Long updateBy;

	/**
	 * 最后修改时间
	 */
  	@Column(name = "update_date")
	private Date updateDate;

	/**
	 * 是否有效（0-无效，1-有效）
	 */
  	@Column(name = "is_valid")
	private Boolean isValid;

}
