package cn.smarthse.services.wanda.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName ChuangdePullRiskClue
 * @Description 风险线索数据-采集--单条风险
 * @Author 曾华川
 * @Date 2023年10月11日 13:59
 * @Version v1.0
 **/
@TableName("chuangde_pull_risk_clue")
public @Data
class ChuangdePullRiskClue extends ChuangdePullBaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @JsonIgnore
    private Long id;

    /**
     * 个性化系统ID
     */
    private String systemId;

    /**
     * 风险规则ID
     * @see cn.smarthse.services.wanda.api.enums.RiskInfoConstants
     */
    private String ruleId;

    /**
     * 风险唯一标识：各个系统生成的唯一ID，以方便反馈及结果查询
     * 唯一 ID 生成规则：风险系统 ID + 风险规则 ID+标识字符串
     * 当风险唯一标识已存在时，更新这条风险线索，解除风险或已成功上报互联网+的数据不允许更新或删除
     */
    private String uniqueId;

    /**
     * 企业id
     */
    @JsonIgnore
    private Long companyId;

    /**
     * 企业名称
     */
    @JsonIgnore
    private String companyName;

    /**
     * 风险识别日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date riskDate;

    /**
     * 统一社会信用代码，当监管主体类型为企业时必填
     */
    private String creditCode;

    /**
     * 风险发生的地点
     */
    private String riskLocation;

    /**
     * 风险主体所在地行政区划，如330000，精确到区县
     */
    private String riskArea;

    /**
     * 风险主体唯一标识
     */
    private String riskMainpartId;

    /**
     * 风险主体名称
     */
    private String riskMainpartName;

    /**
     * 风险标题
     */
    private String riskTitle;

    /**
     * 描述风险的内容
     */
    private String riskContent;

    /**
     * 预警来源，如网络举报
     */
    private String riskResource;

    /**
     * 可访问的 url 地址，作为风险线索的相关辅助材料
     */
    private String fileUrl;

    /**
     *   处理风险预警信息单位的区域代码
     */
    private String regionCode;

    /**
     * 处理风险预警信息单位的机构编码
     */
    private String orgcode;

    /**
     *   指定处置截止时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date handleDate;

    /**
     * 处置人员手机号
     */
    private String handlePersonPhone;

    /**
     * 电子固证信息 URL，字符串数组，最多传 100 个
     */
    private String solidUrls;
    @TableField(exist = false)
    private String urls;

    /**
     * 删除标识: 当 isDelete=1 时，删除已存在库中风险，
     *          当 isDelete=0 或不传时，新增或更新风险唯一标识对应风险线索记录
     */
    private Integer isDelete = 0;

    /**
     * 监管主体类型：1.无主体 2.企业 3.自然人
     */
    private Integer objectType;

    /**
     *  自然人身份证号码，当监管主体类型为 自然人时必填
     */
    private String idCard;

    /**
     * 推送失败原因
     */
    @JsonIgnore
    private String errorMessage;

    /**
     * 生成的风险类型
     */
    private String generationSource;

    /**
     * 企业当时的区域id
     */
    private Long companyAreaId;

    /**
     * 未及时化解风险企业拟推送表id
     */
    private Long workId;

    @TableField(exist = false)
    private Long areaId;
    @TableField(exist = false)
    private Long cityId;
}
