package cn.smarthse.services.wanda.api.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Title: ChuangdePullBaseEntity
 * @Description: TODO
 * @author 曾华川
 * @date 2023-10-17 09:59:43
 */
@ApiModel
public @Data
class ChuangdePullBaseEntity implements Serializable {

    @JsonIgnore
    //0未处理， 1处理中， 2 已处理， 3推送失败
    private Integer isProc;

    @JsonIgnore
    //1新增数据， 0表示数据有修改 推送时需要
    private Boolean isAdd;

    @JsonIgnore
    //是否需要推送， 新增和修改后都需要重置为1 表示需要推送
    private Integer needPull;

    @JsonIgnore
    //最后推送时间
    private Date lastPullDate;

    @JsonIgnore
    //创建时间
    private Date createDate;

    @JsonIgnore
    //创建人
    private Long createBy;

    @JsonIgnore
    //最后修改时间
    private Date updateDate;

    @JsonIgnore
    //最后修改人ID
    private Long updateBy;

    @JsonIgnore
    //是否有效（0-无效，1-有效）
    private Boolean isValid;

    @JsonIgnore
    // 数据源ID
    private String sourceId;

    @JsonIgnore
    //推送次数（超过三次停止推送）
    private int pushNum;
}
