package cn.smarthse.services.wanda.api.entity;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;


@Data
@Accessors(chain = true)
public class ChuangdeParam extends ChuangdePushRiskData implements Serializable {

    private static final long serialVersionUID = 1L;

    private List<Long> idList;
    /**
     * 推送区县地址
     */
    private Long areaId;
    private List<Long> areaIdList;
    private Long cityId;
    private List<Long> cityIdList;

    /**
     * 推送企业cid集合
     */
    private List<Long> companyIdList;

    /**
     * 是否需要变更为执法状态
     */
    private Boolean isChangeLawStatus = true;

    /**
     * 查询那张表：1：chuangde_pull_risk_clue 2：chuangde_push_risk_data 3：chuangde_work_propose_push
     */
    private Integer searchTable;

    /**
     * 是否显示本级企业
     */
    private Boolean onlyThisLevel;

    /**
     * 本级属性
     */
    private Integer belongType;

    /**
     * 搜索的区域和等级
     */
    private Long searchAreaId;
    private Byte searchAreaLevel;

    /**
     * 关键字搜索，企业名称或者信用代码
     */
    private String keyWord;

    /**
     * 页码
     */
    Integer page = 1;

    /**
     * 是否推送成功
     */
    Boolean procState;

    /**
     * 风险类型字符串拼接
     */
    private String generationSourceStr;

}
