package cn.smarthse.township.syn.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 添加巡查项 参数对象
 *
 * @author chuhy
 * @date 2023/4/16
 */
@Data
public class DyPatrolItemParam implements Serializable {
    private static final long serialVersionUID = 3469214676201448513L;

    @ApiModelProperty(value = "有无职业病危害因素定期检测或评价（1-有检测；0-无检测）", required = true, example = "1")
    private Integer ifExistsCheck;

    @ApiModelProperty(value = "有无申报（1-有申报；0-无申报）", required = true, example = "0")
    private Integer ifExistsDeclare;

    @ApiModelProperty(value = "有无职业健康检查（1-有检查；0-无检查）", required = true, example = "1")
    private Integer ifExistsHealth;

    @ApiModelProperty(value = "有无建立职业卫生管理档案（1-有建立；0-无建立）", required = true, example = "0")
    private Integer ifExistsHseFile;

    @ApiModelProperty(value = "有无防护用品（1-有；0-无）", required = true, example = "1")
    private Integer ifExistsPpe;

    @ApiModelProperty(value = "有无开展建设项目三同时（1-有；0-无）", required = true, example = "0")
    private Integer ifExistsThree;

    @ApiModelProperty(value = "有无主要负责人和职业卫生管理人员培训（1-有；0-无）", required = true, example = "1")
    private Integer ifExistsTrain;

    @ApiModelProperty(value = "有无警示标识（1-有；0-无）", required = true, example = "0")
    private Integer ifExistsWarning;
}
