package cn.smarthse.township.syn.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 添加巡查 参数对象
 *
 * @author chuhy
 * * @date 2023/4/16
 */
@Data
public class DyPatrolInfoParam implements Serializable {
    private static final long serialVersionUID = 340280676631594798L;

    @NotNull
    @ApiModelProperty(value = "外部巡查id", required = true, example = "1")
    @Length(max = 100)
    private String sourceId;

    @NotNull(message = "")
    @ApiModelProperty(value = "外部系统单位id", required = true, example = "1636239935179280386")
    private String externalSystemCompanyId;

    @NotNull(message = "")
    @ApiModelProperty(value = "本系统内单位id", example = "7")
    private Long cid;

    @NotNull(message = "")
    @ApiModelProperty(value = "单位名称", required = true, example = "演示企业1")
    private String unitName;

    @NotNull(message = "")
    @ApiModelProperty(value = "单位营业状态(0-已关闭；1-正常营业；2-暂停营业)", required = true, example = "1")
    private Integer unitStatus;

    // @NotNull(message = "")
    // @ApiModelProperty(value = "单位所在街道行政区划id", required = true, example = "330783001000")
    // private Long streetId;

    @NotNull(message = "")
    @ApiModelProperty(value = "巡查名称", required = false, example = "第1次-演示企业1巡查")
    @Length(max = 100)
    private String patrolName;

    @NotNull(message = "")
    @ApiModelProperty(value = "巡查年份", required = true, example = "2023")
    private Integer year;

    @ApiModelProperty(value = "巡查用户id", required = true)
    @NotNull(message = "巡查用户id不能为空")
    private String dataSourceId;

    @NotNull(message = "")
    @ApiModelProperty(value = "巡查人", required = true, example = "张三")
    @Length(max = 20)
    private String patrolPeople;

    @NotNull(message = "")
    @ApiModelProperty(value = "巡查人手机号", required = true, example = "13298765432")
    @Length(max = 20)
    private String patrolPeopleMobile;

    @NotNull(message = "")
    @ApiModelProperty(value = "巡查时间（时间戳ms）", example = "1681532004000", required = true)
    private Date patrolTime;


    @ApiModelProperty(value = "指导员姓名", required = false, example = "李四")
    @Length(max = 20)
    private String guidePeople;

    @NotEmpty
    @ApiModelProperty(value = "巡查痕迹附件", required = true)
    private List<FileParam> patrolFileList;

    @NotEmpty
    @ApiModelProperty(value = "企业负责人签字附件", required = true)
    private List<FileParam> unitManageSignList;

    @NotNull(message = "")
    @ApiModelProperty(value = "巡查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止)", example = "2", hidden = true)
    private Integer patrolStatus = 2;

    @NotNull(message = "")
    @ApiModelProperty(value = "巡查中止类型(0-无；1-拟暂停；2-拟关闭；3-拟迁移；4-拟恢复)", example = "0")
    private Integer stopType;

    @NotNull(message = "")
    @ApiModelProperty(value = "来源（1-乡镇协管；2-外部系统同步）", hidden = true)
    private Integer sourceType = 2;

    public List<FileParam> getUnitManageSignFile() {
        return unitManageSignList != null ? Collections.singletonList(unitManageSignList.get(0)) : null;
    }
}
