package cn.smarthse.township.manage.vo.home;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * 监管：首页 协管员配备率
 *
 * @Author chuhy
 * @Date 2023/10/9 15:21
 */
@Data
public class HomeEquipRateListVo implements Serializable {
    private static final long serialVersionUID = 3059360570713456922L;


    private Long areaId;
    private Long areaId1;
    private Long areaId2;
    private String areaName;

    /**
     * 协管员人数
     */
    private Integer peopleNum;

    /**
     * 应配备协管员镇街数（家）
     */
    private Integer street;

    /**
     * 已配备协管员镇街数（家）
     */
    private Integer street2;

    /**
     * 协管员配备率
     */
    private String equipRate;

    public String getEquipRate() {
        BigDecimal result = this.rateProcessing(this.street, this.street2);
        return result == null ? "-" : result + "%";
    }

    public BigDecimal rateProcessing(int a, int b) {

        boolean aFlag = (a == 0);
        boolean bFlag = (b == 0);

        if (aFlag) return new BigDecimal("0.00");
        if (bFlag) return null;

        BigDecimal aDecimal = new BigDecimal(a);
        BigDecimal bDecimal = new BigDecimal(b);
        return aDecimal.multiply(new BigDecimal(100)).divide(bDecimal, 2, RoundingMode.HALF_UP);
    }
}
