package cn.smarthse.township.manage.vo.company;

import cn.smarthse.common.util.date.DateUtil;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;

/**
 * 企业端——风险告知——未完成整改风险汇总
 *
 * @author ShenZQ
 * @since 2023/3/10 10:02
 */
@Data
public class CompanyRiskNotificationItemVo implements Serializable {

    private static final long serialVersionUID = -7854089995070485041L;

    /**
     * 巡查id
     */
    private Long patrolId;
    /**
     * 风险id
     */
    private Long reformId;
    /**
     * 整改记录id
     */
    private Long reformRecordId;
    /**
     * 风险名
     */
    private String reformName;
    /**
     * 发现时间
     */
    private Date findTime;
    private String findTimeStr;
    /**
     * 整改时间
     */
    private Date actualFinishTime;
    private String actualFinishTimeStr;
    /**
     * 验收时间
     */
    private Date acceptanceDate;
    private String acceptanceDateStr;

    /**
     * 整改措施
     */
    private String reformMeasure;

    public String getFindTimeStr() {
        if (Objects.isNull(this.findTime)) {
            return "-";
        } else {
            return DateUtil.format(this.findTime, "yyyy/MM/dd");
        }
    }

    public String getActualFinishTimeStr() {
        if (Objects.isNull(this.actualFinishTime)) {
            return "-";
        } else {
            return DateUtil.format(this.actualFinishTime, "yyyy/MM/dd");
        }
    }

    public String getAcceptanceDateStr() {
        if (Objects.isNull(this.acceptanceDate)) {
            return "-";
        } else {
            return DateUtil.format(this.acceptanceDate, "yyyy/MM/dd");
        }
    }
}
