package cn.smarthse.township.manage.vo.company;

import cn.smarthse.common.util.date.DateUtil;
import lombok.Data;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 企业端——风险告知
 *
 * @author ShenZQ
 * @since 2023/3/10 9:43
 */
@Data
public class CompanyRiskNotificationDataVo implements Serializable {

    private static final long serialVersionUID = 3635808070046493360L;

    /**
     * 巡查名称
     */
    private String patrolName;
    /**
     * 巡查人
     */
    private String patrolPeople;
    /**
     * 巡查时间
     */
    private Date patrolTime;
    private String patrolTimeStr;
    /**
     * 主要负责人
     */
    private String manager;
    /**
     * 企业负责人签字
     */
    private Long unitManageSign;
    /**
     * 指导员姓名
     */
    private String guidePeople;

    /**
     * 未完成整改风险汇总
     */
    private List<CompanyRiskNotificationItemVo> companyRiskNotificationItemVoList;


    public String getPatrolTimeStr() {
        if (Objects.isNull(this.patrolTime)) {
            return "-";
        } else {
            return DateUtil.format(this.patrolTime, "yyyy/MM/dd");
        }
    }

}
