package cn.smarthse.township.manage.vo.company;

import cn.smarthse.common.util.date.DateUtil;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;

/**
 * 系统参考数据
 *
 * @author ShenZQ
 * @since 2023/3/16 14:32
 */
@Data
@Accessors(chain = true)
public class CompanyPatrolSystemDataVo implements Serializable {

    private static final long serialVersionUID = 7549351126799458728L;

    /**
     * 申报时间
     */
    private Date reportTime;
    private String reportTimeStr;

    /**
     * 体检时间
     */
    private Date physicalExamTime;
    private String physicalExamTimeStr;

    /**
     * 定期检测
     */
    private LocalDateTime regularInspectionTime;
    private String regularInspectionTimeStr;

    /**
     * 评价时间
     */
    private Date appraiseTime;
    private String appraiseTimeStr;

    /**
     * 主要负责人培训证书
     */
    private Date personCertificateTime;
    private String personCertificateStr;

    /**
     * 职业卫生管理人员证书培训
     */
    private Date trainingCertificateTime;
    private String trainingCertificateStr;

    /**
     * 已开展三同时项目数
     */
    private String tsProjectSimpleNum;

    public void setReportTimeStr(Date reportTime) {
        if (Objects.nonNull(reportTime)) {
            this.reportTimeStr = DateUtil.format(reportTime, "yyyy/MM/dd");
        } else {
            this.reportTimeStr = "无数据";
        }
    }

    public void setPhysicalExamTimeStr(Date physicalExamTime) {
        if (Objects.nonNull(physicalExamTime)) {
            this.physicalExamTimeStr = DateUtil.format(physicalExamTime, "yyyy/MM/dd");
        } else {
            this.physicalExamTimeStr = "无数据";
        }
    }

    public void setRegularInspectionTimeStr(LocalDateTime regularInspectionTime) {
        if (Objects.nonNull(regularInspectionTime)) {
            this.regularInspectionTimeStr = regularInspectionTime.toLocalDate().format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
        } else {
            this.regularInspectionTimeStr = "无数据";
        }
    }

    public void setPersonCertificateStr(Date personCertificateTime) {
        if (Objects.nonNull(personCertificateTime)) {
            if (personCertificateTime.after(new Date())) {
                this.personCertificateStr = "有效";
            } else {
                this.personCertificateStr = "无效";
            }
        } else {
            this.personCertificateStr = "无效";
        }
    }

    public void setTrainingCertificateStr(Date trainingCertificateTime) {
        if (Objects.nonNull(trainingCertificateTime)) {
            if (trainingCertificateTime.after(new Date())) {
                this.trainingCertificateStr = "有效";
            } else {
                this.trainingCertificateStr = "无效";
            }
        } else {
            this.personCertificateStr = "无效";
        }
    }

    public void setAppraiseTimeStr(Date appraiseTime) {
        if (Objects.nonNull(appraiseTime)) {
            this.appraiseTimeStr = DateUtil.format(appraiseTime, "yyyy/MM/dd");
        } else {
            this.appraiseTimeStr = "无数据";
        }
    }
}
