package cn.smarthse.township.manage.vo.company;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 企业端——巡查详情——巡查项信息
 *
 * @author chuhy
 * @since 2023-03-08 11:01
 */
@Data
public class CompanyPatrolItemVo implements Serializable {

    private static final long serialVersionUID = 3253957876297508394L;

    /**
     * 有无申报（1-有；0-无）
     */
    private Integer ifExistsDeclare;

    /**
     * 最近一次申报日期
     */
    private Date declareDate;

    /**
     * 有无职业健康检查（1-有；0-无）
     */
    private Integer ifExistsHealth;

    /**
     * 最近一次职业健康检查日期
     */
    private Date healthDate;

    /**
     * 有无职业病危害因素定期检测或评价（1-有；0-无）
     */
    private Integer ifExistsCheck;

    /**
     * 最近一次定期检测日期
     */
    private Date checkDate;

    /**
     * 最近一次评价日期
     */
    private Date evalDate;

    /**
     * 有无,主要负责人和职业卫生管理人员培训（1-有；0-无）
     */
    private Integer ifExistsTrain;

    /**
     * 主要负责人培训证书(0-无数据; 1-失效; 2-有效)
     */
    private Integer trainMianData;

    /**
     * 职业卫生管理人员培训证书(0-无数据; 1-失效; 2-有效)
     */
    private Integer trainManageData;

    /**
     * 有无开展建设项目三同时（1-有；0-无；2-合理缺项）
     */
    private Integer ifExistsThree;

    /**
     * 已开展三同时项目数
     */
    private Integer threeNum;

    /**
     * 有无防护用品（1-有；0-无）
     */
    private Integer ifExistsPpe;

    /**
     * 有无警示标识（1-有；0-无）
     */
    private Integer ifExistsWarning;

    /**
     * 有无建立职业卫生管理档案（1-有；0-无）
     */
    private Integer ifExistsHseFile;

    /**
     * 三同时档案-本年
     */
    private String hseFileThree;

    /**
     * 三同时档案-上年
     */
    private String hseFileThreeLast;

    /**
     * 职业卫生管理档案-本年
     */
    private String hseFileManage;

    /**
     * 职业卫生管理档案-上年
     */
    private String hseFileManageLast;

    /**
     * 职业卫生宣传培训档案-本年
     */
    private String hseFileTrain;

    /**
     * 职业卫生宣传培训档案-本年
     */
    private String hseFileTrainLast;

    /**
     * 检测与评价档案-本年
     */
    private String hseFileCheck;

    /**
     * 检测与评价档案-上年
     */
    private String hseFileCheckLast;

    /**
     * 用人单位职业健康监护管理档案-本年
     */
    private String hseFileUnitHealth;

    /**
     * 用人单位职业健康监护管理档案-上年
     */
    private String hseFileUnitHealthLast;

    /**
     * 劳动者个人职业健康监护档案-本年
     */
    private String hseFileStaffHealth;

    /**
     * 劳动者个人职业健康监护档案-上年
     */
    private String hseFileStaffHealthLast;

}
