package cn.smarthse.township.manage.vo.company;

import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import lombok.Data;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;

/**
 * 企业端——巡查详情——巡查记录信息
 *
 * @author chuhy
 * @since 2023-03-08 11:01
 */
@Data
public class CompanyPatrolInfoVo implements Serializable {

    private static final long serialVersionUID = 6429095980825064017L;

    /**
     * 巡查记录id
     */
    private Long id;

    /**
     * 巡查名称
     */
    private String patrolName;

    /**
     * 单位id
     */
    private Long cid;

    /**
     * 单位名称
     */
    private String unitName;

    /**
     * 单位营业状态
     */
    private Integer unitStatus;

    /**
     * 主要负责人
     */
    private String manager;

    /**
     * 联系电话
     */
    private String tel;

    /**
     * 职业健康管理人员
     */
    private String hseManager;

    /**
     * 职业健康管理人员-联系电话
     */
    private String hesTel;

    /**
     * 行政区划地址
     */
    private String address;

    /**
     * 工作场所地址
     */
    private String workAddress;

    /**
     * 行政区划
     */
    private Long areaId;

    /**
     * 行业编码
     */
    private String industryCode;
    private String industryName;

    /**
     * 规模
     */
    private String scaleCode;
    private String scaleName;

    /**
     * 经济
     */
    private String economyCode;
    private String economyName;

    /**
     * 巡查年份
     */
    private Integer year;

    /**
     * 巡查人
     */
    private String patrolPeople;

    /**
     * 巡查时间
     */
    private Date patrolTime;
    private String patrolTimeStr;

    /**
     * 巡查痕迹附件
     */
    private String patrolFile;

    /**
     * 巡查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止)
     */
    private Integer patrolStatus;

    /**
     * 中止类型(1-企业暂停；2-企业关闭；3-区域变更)
     */
    private Integer stopType;


    public String getScaleName() {
        if (scaleCode != null) {
            return CompanySizeEnum.getName(Integer.valueOf(scaleCode));
        } else {
            return null;
        }
    }

    public String getPatrolTimeStr() {
        if (Objects.isNull(this.patrolTime)) {
            return "-";
        } else {
            return DateUtil.format(this.patrolTime, "yyyy/MM/dd");
        }
    }
}
